/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;

public class CastingRecipeWrapper
extends BlankRecipeWrapper {
    protected final List<ItemStack> cast;
    protected final List<FluidStack> inputFluid;
    protected List<ItemStack> output;
    public final IDrawable castingBlock;
    private final CastingRecipe recipe;

    public CastingRecipeWrapper(List<ItemStack> casts, CastingRecipe recipe, IDrawable castingBlock) {
        this.cast = casts;
        this.recipe = recipe;
        this.inputFluid = ImmutableList.of((Object)recipe.getFluid());
        this.output = ImmutableList.of((Object)recipe.getResult());
        this.castingBlock = castingBlock;
    }

    public CastingRecipeWrapper(CastingRecipe recipe, IDrawable castingBlock) {
        this.cast = recipe.cast != null ? recipe.cast.getInputs() : ImmutableList.of();
        this.inputFluid = ImmutableList.of((Object)recipe.getFluid());
        this.recipe = recipe;
        this.output = recipe.getResult() == null ? null : ImmutableList.of((Object)recipe.getResult());
        this.castingBlock = castingBlock;
    }

    public boolean hasCast() {
        return this.recipe.cast != null;
    }

    public List<FluidStack> getFluidInputs() {
        return this.inputFluid;
    }

    public List getInputs() {
        if (this.cast == null) {
            return super.getInputs();
        }
        return this.cast;
    }

    public List getOutputs() {
        if (this.output == null) {
            if (this.recipe.getResult() == null) {
                return ImmutableList.of();
            }
            this.output = ImmutableList.of((Object)this.recipe.getResult());
        }
        return this.output;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        this.castingBlock.draw(minecraft, 59, 42);
        String s = String.format("%d s", this.recipe.getTime() / 20);
        int x = 92;
        minecraft.fontRendererObj.drawString(s, x -= minecraft.fontRendererObj.getStringWidth(s) / 2, 16, Color.gray.getRGB());
        if (this.recipe.consumesCast()) {
            minecraft.fontRendererObj.drawString(Util.translate("gui.jei.casting.consume", new Object[0]), 78, 48, 0xAA0000);
        }
    }
}

