/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.smeltery;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;

public class SmelteryTank {
    protected final ISmelteryTankHandler parent;
    protected List<FluidStack> liquids = Lists.newArrayList();
    protected int maxCapacity = 0;

    public SmelteryTank(ISmelteryTankHandler parent) {
        this.parent = parent;
    }

    public void setCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public List<FluidStack> getFluids() {
        return this.liquids;
    }

    public void setFluids(List<FluidStack> fluids) {
        this.liquids = fluids;
        this.parent.onTankChanged(this.liquids, null);
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getUsedCapacity() {
        int cap = 0;
        for (FluidStack liquid : this.liquids) {
            cap += liquid.amount;
        }
        return cap;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int used = this.getUsedCapacity();
        int usable = Math.min(this.maxCapacity - used, resource.amount);
        if (!doFill) {
            return usable;
        }
        for (FluidStack liquid : this.liquids) {
            if (!liquid.isFluidEqual(resource)) continue;
            liquid.amount += usable;
            this.parent.onTankChanged(this.liquids, liquid);
            return usable;
        }
        resource = resource.copy();
        resource.amount = usable;
        this.liquids.add(resource);
        this.parent.onTankChanged(this.liquids, resource);
        return usable;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquids.isEmpty()) {
            return null;
        }
        FluidStack liquid = new FluidStack(this.liquids.get(0), maxDrain);
        return this.drain(liquid, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        ListIterator<FluidStack> iter = this.liquids.listIterator();
        while (iter.hasNext()) {
            FluidStack liquid = iter.next();
            if (!liquid.isFluidEqual(resource)) continue;
            int drainable = Math.min(resource.amount, liquid.amount);
            if (doDrain) {
                liquid.amount -= drainable;
                if (liquid.amount <= 0) {
                    iter.remove();
                }
                this.parent.onTankChanged(this.liquids, liquid);
            }
            resource = resource.copy();
            resource.amount = drainable;
            return resource;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.liquids) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            liquid.writeToNBT(fluidTag);
            taglist.appendTag((NBTBase)fluidTag);
        }
        tag.setTag("Liquids", (NBTBase)taglist);
        tag.setInteger("LiquidCapacity", this.maxCapacity);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList taglist = tag.getTagList("Liquids", 10);
        this.liquids.clear();
        for (int i = 0; i < taglist.tagCount(); ++i) {
            NBTTagCompound fluidTag = taglist.getCompoundTagAt(i);
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            if (liquid == null) continue;
            this.liquids.add(liquid);
        }
        this.maxCapacity = tag.getInteger("LiquidCapacity");
    }

    public void moveFluidToBottom(int index) {
        if (index < this.liquids.size()) {
            FluidStack fluid = this.liquids.get(index);
            this.liquids.remove(index);
            this.liquids.add(0, fluid);
        }
    }
}

