/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.geom.Ellipse2D;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeVine;
import slimeknights.tconstruct.world.worldgen.SlimeIslandData;
import slimeknights.tconstruct.world.worldgen.SlimeLakeGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePlantGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class SlimeIslandGenerator
implements IWorldGenerator {
    public static SlimeIslandGenerator INSTANCE = new SlimeIslandGenerator();
    protected int randomness = 1;
    protected SlimeLakeGenerator lakeGenGreen;
    protected SlimeLakeGenerator lakeGenBlue;
    protected SlimeLakeGenerator lakeGenPurple;
    protected SlimePlantGenerator plantGenBlue;
    protected SlimePlantGenerator plantGenPurple;
    protected SlimeTreeGenerator treeGenBlue;
    protected SlimeTreeGenerator treeGenPurple;
    protected IBlockState air;
    protected TIntObjectHashMap<SlimeIslandData> islandData = new TIntObjectHashMap();

    public SlimeIslandGenerator() {
        this.air = Blocks.air.getDefaultState();
        IBlockState slimeGreen = TinkerWorld.slimeBlockCongealed.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.GREEN));
        IBlockState slimeBlue = TinkerWorld.slimeBlockCongealed.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.BLUE));
        IBlockState slimePurple = TinkerWorld.slimeBlockCongealed.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.PURPLE));
        IBlockState leaves = TinkerWorld.slimeLeaves.getDefaultState();
        IBlockState slimeFLuidBlue = Blocks.water.getDefaultState();
        IBlockState slimeFLuidPurple = Blocks.water.getDefaultState();
        if (TinkerFluids.blueslime != null) {
            slimeFLuidPurple = slimeFLuidBlue = TinkerFluids.blueslime.getBlock().getDefaultState();
        }
        if (TinkerFluids.purpleSlime != null) {
            slimeFLuidPurple = TinkerFluids.purpleSlime.getBlock().getDefaultState();
        }
        this.lakeGenGreen = new SlimeLakeGenerator(slimeFLuidBlue, slimeGreen, slimeGreen, slimeBlue);
        this.lakeGenBlue = new SlimeLakeGenerator(slimeFLuidBlue, slimeBlue, slimeGreen, slimeBlue);
        this.lakeGenPurple = new SlimeLakeGenerator(slimeFLuidPurple, slimePurple, slimePurple);
        this.treeGenBlue = new SlimeTreeGenerator(5, 4, slimeGreen, leaves.withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.BLUE)), TinkerWorld.slimeVineBlue3.getDefaultState());
        this.treeGenPurple = new SlimeTreeGenerator(5, 4, slimeGreen, leaves.withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.PURPLE)), TinkerWorld.slimeVinePurple3.getDefaultState());
        this.plantGenBlue = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.BLUE, false);
        this.plantGenPurple = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.PURPLE, false);
    }

    public boolean isSlimeIslandAt(World world, BlockPos pos) {
        for (StructureBoundingBox data : this.getIslandData((World)world).islands) {
            if (!data.isVecInside((Vec3i)pos)) continue;
            return true;
        }
        return false;
    }

    protected String getDataName() {
        return "SlimeIslands";
    }

    protected SlimeIslandData getIslandData(World world) {
        int dimensionId = world.provider.getDimensionId();
        if (!this.islandData.containsKey(dimensionId)) {
            SlimeIslandData data = (SlimeIslandData)world.getPerWorldStorage().loadData(SlimeIslandData.class, this.getDataName());
            if (data == null) {
                data = new SlimeIslandData(this.getDataName());
                world.getPerWorldStorage().setData(this.getDataName(), (WorldSavedData)data);
            }
            this.islandData.put(dimensionId, (Object)data);
        }
        return (SlimeIslandData)((Object)this.islandData.get(dimensionId));
    }

    protected boolean shouldGenerateInDimension(int id) {
        for (int dim : Config.slimeIslandBlacklist) {
            if (dim != id) continue;
            return false;
        }
        return true;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!Config.genSlimeIslands) {
            return;
        }
        if (world.getWorldType() == WorldType.FLAT && !Config.genIslandsInSuperflat) {
            return;
        }
        if (!this.shouldGenerateInDimension(world.provider.getDimensionId())) {
            return;
        }
        if (random.nextInt(Config.slimeIslandsRate) > 0) {
            return;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.BLUE;
        BlockSlimeDirt.DirtType dirt = BlockSlimeDirt.DirtType.BLUE;
        SlimeLakeGenerator lakeGen = this.lakeGenBlue;
        SlimePlantGenerator plantGen = this.plantGenPurple;
        SlimeTreeGenerator treeGen = this.treeGenPurple;
        IBlockState vine = TinkerWorld.slimeVineBlue1.getDefaultState();
        int rnr = random.nextInt(10);
        if (rnr <= 1) {
            grass = BlockSlimeGrass.FoliageType.PURPLE;
            dirt = BlockSlimeDirt.DirtType.PURPLE;
            lakeGen = this.lakeGenPurple;
            treeGen = this.treeGenBlue;
            plantGen = this.plantGenBlue;
            vine = TinkerWorld.slimeVinePurple1.getDefaultState();
        } else if (rnr < 6) {
            dirt = BlockSlimeDirt.DirtType.GREEN;
            lakeGen = this.lakeGenGreen;
        }
        IBlockState dirtState = TinkerWorld.slimeDirt.getDefaultState().withProperty(BlockSlimeDirt.TYPE, (Comparable)((Object)dirt));
        IBlockState grassState = TinkerWorld.slimeGrass.getStateFromDirt(dirtState).withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass));
        int x = chunkX * 16 + 7 + random.nextInt(6) - 3;
        int z = chunkZ * 16 + 7 + random.nextInt(6) - 3;
        int y = world.getHeight(new BlockPos(x, 0, z)).getY() + 50 + random.nextInt(50) + 11;
        this.generateIsland(random, world, x, z, y, dirtState, grassState, vine, lakeGen, treeGen, plantGen);
    }

    public void generateIsland(Random random, World world, int xPos, int zPos, int ySurfacePos, IBlockState dirt, IBlockState grass, IBlockState vine, SlimeLakeGenerator lakeGenerator, SlimeTreeGenerator treeGenerator, SlimePlantGenerator plantGen) {
        int i;
        BlockPos pos2;
        BlockPos pos1;
        int y;
        int z;
        int x;
        int yRange;
        int xRange = 20 + random.nextInt(13);
        int zRange = 20 + random.nextInt(13);
        int height = yRange = 11 + random.nextInt(3);
        int yBottom = ySurfacePos - yRange;
        BlockPos center = new BlockPos(xPos, yBottom + height, zPos);
        BlockPos start = new BlockPos(xPos - xRange / 2, yBottom, zPos - zRange / 2);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, xRange, zRange);
        for (int x2 = 0; x2 <= xRange; ++x2) {
            for (int z2 = 0; z2 <= zRange; ++z2) {
                for (int y2 = 0; y2 <= yRange; ++y2) {
                    if (!ellipse.contains(x2, z2)) continue;
                    world.setBlockState(start.add(x2, y2, z2), dirt, 2);
                }
            }
        }
        int erode_height = 8;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= erode_height; ++y) {
                    pos1 = start.add(x, erode_height - y, z);
                    pos2 = start.add(xRange - x, erode_height - y, zRange - z);
                    for (BlockPos pos : new BlockPos[]{pos1, pos2}) {
                        if (world.getBlockState(pos) != dirt || world.getBlockState(pos.add(-1, 1, 0)) == dirt && world.getBlockState(pos.add(1, 1, 0)) == dirt && world.getBlockState(pos.add(0, 1, -1)) == dirt && world.getBlockState(pos.add(-1, 1, 1)) == dirt && random.nextInt(100) > this.randomness) continue;
                        world.setBlockState(pos, this.air, 2);
                    }
                }
            }
        }
        erode_height = 2;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= erode_height; ++y) {
                    pos1 = start.add(x, y + height - erode_height + 2, z);
                    pos2 = start.add(xRange - x, y + height - erode_height + 2, zRange - z);
                    for (BlockPos pos : new BlockPos[]{pos1, pos2}) {
                        BlockPos below = pos.down();
                        if (world.getBlockState(below.north()) == dirt && world.getBlockState(below.east()) == dirt && world.getBlockState(below.south()) == dirt && world.getBlockState(below.west()) == dirt) continue;
                        world.setBlockState(pos, Blocks.air.getDefaultState(), 2);
                    }
                }
            }
        }
        for (x = 0; x <= xRange; ++x) {
            block12: for (z = 0; z <= zRange; ++z) {
                BlockPos top = start.add(x, height, z);
                for (int y3 = 0; y3 <= height; ++y3) {
                    BlockPos pos = top.down(y3);
                    if (world.getBlockState(pos) != dirt || !world.isAirBlock(pos.up())) continue;
                    world.setBlockState(pos, grass, 2);
                    continue block12;
                }
            }
        }
        if (lakeGenerator != null) {
            lakeGenerator.generateLake(random, world, center);
        }
        if (plantGen != null) {
            plantGen.generatePlants(random, world, start.up(height + 1), start.add(xRange, height - 3, zRange), 128);
        }
        if (treeGenerator != null) {
            for (i = 0; i < 3; ++i) {
                BlockPos pos = start.add(random.nextInt(xRange), height, random.nextInt(zRange));
                treeGenerator.generateTree(random, world, pos);
            }
        }
        if (vine != null) {
            for (i = 0; i < 30; ++i) {
                BlockPos pos = start.add(-1 + random.nextInt(xRange + 2), 0, -1 + random.nextInt(zRange + 2));
                this.tryPlacingVine(random, world, pos, height, vine);
            }
        }
        SlimeIslandData data = this.getIslandData(world);
        data.islands.add(new StructureBoundingBox(start.getX(), start.getY(), start.getZ(), start.getX() + xRange, start.getY() + yRange, start.getZ() + yRange));
        data.markDirty();
    }

    public void tryPlacingVine(Random random, World world, BlockPos below, int limit, IBlockState vine) {
        BlockPos pos = below;
        BlockPos candidate = null;
        for (int i = 0; i < limit; ++i) {
            if ((vine.getBlock().canPlaceBlockOnSide(world, pos, EnumFacing.NORTH) || vine.getBlock().canPlaceBlockOnSide(world, pos, EnumFacing.EAST) || vine.getBlock().canPlaceBlockOnSide(world, pos, EnumFacing.SOUTH) || vine.getBlock().canPlaceBlockOnSide(world, pos, EnumFacing.WEST)) && (candidate == null || random.nextInt(10) == 0)) {
                candidate = pos;
            }
            pos = pos.up();
        }
        if (candidate != null) {
            world.setBlockState(candidate, vine.getBlock().onBlockPlaced(world, candidate, EnumFacing.UP, 0.0f, 0.0f, 0.0f, 0, null), 2);
            pos = candidate;
            for (int size = random.nextInt(8); size >= 0 && world.getBlockState(pos).getBlock() instanceof BlockSlimeVine; ++size) {
                ((BlockSlimeVine)world.getBlockState(pos).getBlock()).grow(world, random, pos, world.getBlockState(pos));
                pos = pos.down();
            }
        }
    }
}

