/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class BlockSlimeLeaves
extends BlockLeaves {
    public BlockSlimeLeaves() {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.setHardness(0.3f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DECAYABLE, (Comparable)Boolean.valueOf(true)));
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.updateTick(worldIn, pos, state, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            list.add(new ItemStack((Block)this, 1, this.getMetaFromState(this.getDefaultState().withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    public boolean isOpaqueCube() {
        return Blocks.leaves.isOpaqueCube();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer getBlockLayer() {
        return Blocks.leaves.getBlockLayer();
    }

    protected int getSaplingDropChance(IBlockState state) {
        return 25;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)TinkerWorld.slimeSapling);
    }

    protected void dropApple(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (worldIn.rand.nextInt(chance) == 0) {
            ItemStack stack = null;
            if (state.getValue(BlockSlimeGrass.FOLIAGE) == BlockSlimeGrass.FoliageType.PURPLE) {
                stack = TinkerCommons.matSlimeBallPurple.copy();
            } else if (state.getValue(BlockSlimeGrass.FOLIAGE) == BlockSlimeGrass.FoliageType.BLUE) {
                stack = worldIn.rand.nextInt(3) == 0 ? TinkerCommons.matSlimeBallBlue.copy() : new ItemStack(Items.slime_ball);
            }
            if (stack != null) {
                BlockSlimeLeaves.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public int damageDropped(IBlockState state) {
        return ((BlockSlimeGrass.FoliageType)((Object)state.getValue(BlockSlimeGrass.FOLIAGE))).ordinal() & 3;
    }

    protected ItemStack createStackedBlock(IBlockState state) {
        return new ItemStack(Item.getItemFromBlock((Block)this), 1, ((BlockSlimeGrass.FoliageType)((Object)state.getValue(BlockSlimeGrass.FOLIAGE))).ordinal() & 3);
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{BlockSlimeGrass.FOLIAGE, CHECK_DECAY, DECAYABLE});
    }

    public IBlockState getStateFromMeta(int meta) {
        int type = meta % 4;
        if (type < 0 || type >= BlockSlimeGrass.FoliageType.values().length) {
            type = 0;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.values()[type];
        return this.getDefaultState().withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass)).withProperty((IProperty)DECAYABLE, (Comparable)Boolean.valueOf((meta & 4) == 0)).withProperty((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int getMetaFromState(IBlockState state) {
        int meta = ((BlockSlimeGrass.FoliageType)((Object)state.getValue(BlockSlimeGrass.FOLIAGE))).ordinal() & 3;
        if (!((Boolean)state.getValue((IProperty)DECAYABLE)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.getValue((IProperty)CHECK_DECAY)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        BlockSlimeGrass.FoliageType foliageType = (BlockSlimeGrass.FoliageType)((Object)state.getValue(BlockSlimeGrass.FOLIAGE));
        return SlimeColorizer.getColorStatic(foliageType);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.getBlockState(pos);
        if (state.getBlock() != this) {
            return this.getBlockColor();
        }
        BlockSlimeGrass.FoliageType foliageType = (BlockSlimeGrass.FoliageType)((Object)state.getValue(BlockSlimeGrass.FOLIAGE));
        return SlimeColorizer.getColorForPos(pos.add(128.0, 0.0, 128.0), foliageType);
    }

    public BlockPlanks.EnumType getWoodType(int meta) {
        throw new NotImplementedException();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.getBlockState(pos);
        return Lists.newArrayList((Object[])new ItemStack[]{this.createStackedBlock(state)});
    }

    public boolean isLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

