package slimeknights.tconstruct.world.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Iterator;
import java.util.List;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.block.BlockSlime.SlimeType;

public class BlockSlimeCongealed extends Block {

  public BlockSlimeCongealed() {
    super(Material.field_151583_m);
    this.func_149647_a(TinkerRegistry.tabWorld);
    this.func_149711_c(0.5f);
    this.field_149765_K = 0.5f;
    this.func_149649_H();
    this.func_149672_a(field_176231_q);
  }


  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(SlimeType type : SlimeType.values()) {
      list.add(new ItemStack(this, 1, type.meta));
    }
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, BlockSlime.TYPE);
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    return this.func_176223_P().func_177226_a(BlockSlime.TYPE, SlimeType.fromMeta(meta));
  }

  @Override
  public int func_176201_c(IBlockState state) {
    return ((SlimeType) state.func_177229_b(BlockSlime.TYPE)).meta;
  }

  @Override
  public int func_180651_a(IBlockState state) {
    return func_176201_c(state);
  }

  @Override
  public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
    return AxisAlignedBB.func_178781_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(),
                                    pos.func_177958_n() + 1.0D, pos.func_177956_o() + 0.625D, pos.func_177952_p() + 1.0D);
  }

  @Override
  public void func_176216_a(World world, Entity entity) {
    if(!(entity instanceof EntityLiving) && !(entity instanceof EntityItem)) {
      return;
    }
    if (entity.field_70181_x < 0)
    {
      if (entity.field_70181_x < -0.08F)
      {
        //world.playSoundEffect(entity.posX, entity.posY, entity.posZ, stepSound.getStepSound(),
          //                    stepSound.getVolume() / 2.0F, stepSound.getFrequency() * 0.65F);
      }
      entity.field_70181_x *= -1.2F;
      if(entity instanceof EntityLiving) {
        //TinkerCommons.potionSlimeBounce.apply((EntityLivingBase) entity);
      }
      if(entity instanceof EntityItem) {
        entity.field_70122_E = false;
      }
    }
  }

  @Override
  public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    // no fall damage on congealed slime
    entityIn.func_180430_e(fallDistance, 0.0F);
  }

  /* Log behaviour for slimetrees */
  @Override
  public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
    return true;
  }

  // this causes leaves to decay when you break the block
  @Override
  public void func_180663_b(World worldIn, BlockPos pos, IBlockState state)
  {
    byte b0 = 4;
    int i = b0 + 1;

    if (worldIn.func_175707_a(pos.func_177982_a(-i, -i, -i), pos.func_177982_a(i, i, i)))
    {

      for(BlockPos blockpos1 : BlockPos.func_177980_a(pos.func_177982_a(-b0, -b0, -b0), pos.func_177982_a(b0, b0, b0))) {
        IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);

        if(iblockstate1.func_177230_c().isLeaves(worldIn, blockpos1)) {
          iblockstate1.func_177230_c().beginLeavesDecay(worldIn, blockpos1);
        }
      }
    }
  }
}
