package slimeknights.tconstruct.tools.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

import java.util.List;

import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class Cleaver extends BroadSword {

  public Cleaver() {
    super(PartMaterialType.handle(TinkerTools.toughToolRod),
          PartMaterialType.head(TinkerTools.largeSwordBlade),
          PartMaterialType.head(TinkerTools.largePlate),
          PartMaterialType.extra(TinkerTools.toughToolRod));
  }

  @Override
  public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
    // no blocking for you
    return itemStackIn;
  }

  @Override
  public float damagePotential() {
    return 0.9f;
  }

  @Override
  public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
    target.field_70172_ad += 12;
    target.field_70737_aN += 12;
    return super.func_77644_a(stack, target, attacker);
  }

  @Override
  public void func_77663_a(ItemStack stack, World worldIn, Entity entity, int itemSlot, boolean isSelected) {
    super.func_77663_a(stack, worldIn, entity, itemSlot, isSelected);
    if (entity instanceof EntityPlayer)
    {
      EntityPlayer player = (EntityPlayer) entity;
      ItemStack equipped = player.func_71045_bC();
      if (equipped == stack)
      {
        player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 2, 2, true, false));
      }
    }
  }

  @Override
  public int[] getRepairParts() {
    return new int[] {1,2};
  }

  @Override
  public NBTTagCompound buildTag(List<Material> materials) {
    HandleMaterialStats handle = materials.get(0).getStatsOrUnknown(HandleMaterialStats.TYPE);
    HeadMaterialStats head     = materials.get(1).getStatsOrUnknown(HeadMaterialStats.TYPE);
    HeadMaterialStats shield   = materials.get(2).getStatsOrUnknown(HeadMaterialStats.TYPE);
    ExtraMaterialStats guard   = materials.get(3).getStatsOrUnknown(ExtraMaterialStats.TYPE);

    ToolNBT data = new ToolNBT();
    data.head(head, shield);
    data.extra(guard);
    data.handle(handle);

    data.attack *= 1.4f;
    data.attack += 2f;

    // triple durability!
    data.durability *= 2f;
    data.modifiers = 2;

    return data.get();
  }
}
