package slimeknights.tconstruct.tools.inventory;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;

public class SlotToolStationIn extends Slot {

  public boolean dormant;
  public PartMaterialType restriction;
  public ItemStack icon;
  public Container parent;

  public SlotToolStationIn(IInventory inventoryIn, int index, int xPosition, int yPosition, Container parent) {
    super(inventoryIn, index, xPosition, yPosition);
    this.parent = parent;
  }

  @Override
  public void func_75218_e() {
    // notify container to update craft result
    parent.func_75130_a(field_75224_c);
  }

  @Override
  public boolean func_75214_a(ItemStack stack) {
    // dormant slots don't take any items, they can only be taken out of
    if(dormant) return false;

    // otherwise we check if we have item info and restrict it to that
    if(restriction != null) {
      if(stack != null && stack.func_77973_b() instanceof IToolPart) {
        return restriction.isValidItem((IToolPart) stack.func_77973_b());
      }
      return false;
    }

    // note that we only take the part into account when it's set. This is because it's only ever set clientside
    return super.func_75214_a(stack);
  }

  public boolean isDormant() {
    return dormant;
  }

  public void activate() {
    dormant = false;
  }

  public void deactivate() {
    dormant = true;
  }


  public void setRestriction(PartMaterialType restriction) {
    this.restriction = restriction;
  }

  @SideOnly(Side.CLIENT)
  public void updateIcon() {
    if(restriction != null) {
      for(IToolPart part : restriction.getPossibleParts()) {
        if(part instanceof MaterialItem) {
          icon = ((MaterialItem) part).getItemstackWithMaterial(CustomTextureCreator.guiMaterial);
          break;
        }
      }
    }
    else {
      icon = null;
    }
  }
}
