package slimeknights.tconstruct.smeltery.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import java.util.Random;

import slimeknights.tconstruct.common.block.BlockInventoryTinkers;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class BlockSmelteryController extends BlockInventoryTinkers {

  public static PropertyDirection FACING = PropertyDirection.func_177712_a("facing", EnumFacing.Plane.HORIZONTAL);
  public static PropertyBool ACTIVE = PropertyBool.func_177716_a("active");

  public BlockSmelteryController() {
    super(Material.field_151576_e);
    this.func_149647_a(TinkerRegistry.tabSmeltery);
    func_149711_c(3F);
    func_149752_b(20F);
    func_149672_a(field_149777_j);

    this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ACTIVE, false));
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, FACING, ACTIVE);
  }

  @Override
  public TileEntity func_149915_a(World worldIn, int meta) {
    return new TileSmeltery();
  }

  @Override
  public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
    // active or inactive?
    return state.func_177226_a(ACTIVE, isActive(worldIn, pos));
  }

  public boolean isActive(IBlockAccess world, BlockPos pos) {
    TileEntity te = world.func_175625_s(pos);
    if(te instanceof TileSmeltery) {
      return ((TileSmeltery) te).isActive();
    }
    return false;
  }

  @Override
  protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
    if(!isActive(world, pos)) {
      return false;
    }
    return super.openGui(player, world, pos);
  }

  @Override
  public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
    // set rotation
    return this.func_176223_P().func_177226_a(FACING, placer.func_174811_aO().func_176734_d());
  }

  // METADATA

  @Override
  public IBlockState func_176203_a(int meta) {
    EnumFacing enumfacing = EnumFacing.func_82600_a(meta);

    if (enumfacing.func_176740_k() == EnumFacing.Axis.Y)
    {
      enumfacing = EnumFacing.NORTH;
    }

    return this.func_176223_P().func_177226_a(FACING, enumfacing);
  }

  @Override
  public int func_176201_c(IBlockState state) {
    return (state.func_177229_b(FACING)).func_176745_a();
  }

  // State updating
  @Override
  public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    TileEntity te = worldIn.func_175625_s(pos);
    if(te instanceof TileSmeltery) {
      ((TileSmeltery) te).checkSmelteryStructure();
    }
  }

  // RENDERING

  @Override
  public int func_149645_b() {
    return 3;
  }

  @Override
  public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    if (isActive(worldIn, pos))
    {
      EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
      double d0 = (double)pos.func_177958_n() + 0.5D;
      double d1 = (double)pos.func_177956_o() + 0.5D + (rand.nextFloat() * 6F) / 16F;
      double d2 = (double)pos.func_177952_p() + 0.5D;
      double d3 = 0.52D;
      double d4 = rand.nextDouble() * 0.6D - 0.3D;

      switch (enumfacing)
      {
        case WEST:
          worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0D, 0.0D, 0.0D);
          worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0D, 0.0D, 0.0D);
          break;
        case EAST:
          worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0D, 0.0D, 0.0D);
          worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0D, 0.0D, 0.0D);
          break;
        case NORTH:
          worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0D, 0.0D, 0.0D);
          worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0D, 0.0D, 0.0D);
          break;
        case SOUTH:
          worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0D, 0.0D, 0.0D);
          worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0D, 0.0D, 0.0D);
      }
    }
  }
}
