package slimeknights.tconstruct.smeltery.block;

import com.google.common.base.Predicate;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;

public class BlockFaucet extends BlockContainer {

  // Facing == input, can be any side except bottom, because down always is output direction
  public static final PropertyDirection FACING = PropertyDirection.func_177712_a("facing", new Predicate<EnumFacing>() {
    @Override
    public boolean apply(@Nullable EnumFacing input) {
      return input != EnumFacing.DOWN;
    }
  });

  public BlockFaucet() {
    super(Material.field_151576_e);

    func_149647_a(TinkerRegistry.tabSmeltery);
    func_149711_c(3F);
    func_149752_b(20F);
    func_149672_a(field_149777_j);
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, FACING);
  }

  /**
   * Convert the given metadata into a BlockState for this Block
   */
  public IBlockState func_176203_a(int meta) {
    if(meta >= EnumFacing.values().length) {
      meta = 1;
    }
    EnumFacing face = EnumFacing.values()[meta];
    if(face == EnumFacing.DOWN) {
      face = EnumFacing.UP;
    }

    return this.func_176223_P().func_177226_a(FACING, face);
  }

  /**
   * Convert the BlockState into the correct metadata value
   */
  public int func_176201_c(IBlockState state) {
    return state.func_177229_b(FACING).ordinal();
  }

  @Override
  public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
    if(playerIn.func_70093_af()) {
      return false;
    }
    TileEntity te = worldIn.func_175625_s(pos);
    if(te instanceof TileFaucet) {
      ((TileFaucet) te).activate();
      return true;
    }
    return super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
  }

  /* Redstone */

  @Override
  public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
    return true;
  }

  @Override
  public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    if(worldIn.field_72995_K) {
      return;
    }
    TileEntity te = worldIn.func_175625_s(pos);
    if(te instanceof TileFaucet) {
      ((TileFaucet) te).handleRedstone(worldIn.func_175640_z(pos));
    }
  }

  /* Bounds */

  @Override
  public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
    EnumFacing facing = worldIn.func_180495_p(pos).func_177229_b(FACING);

    float xMin = 0.25F;
    float xMax = 0.75F;
    float zMin = 0.25F;
    float zMax = 0.75F;
    float yMin = 0.25F;
    float yMax = 0.625F;

    switch(facing) {
      case UP:
        yMin = 0.625F;
        yMax = 1.0F;
        break;
      case SOUTH:
        zMin = 0.625F;
        zMax = 1.0F;
        break;
      case NORTH:
        zMax = 0.375F;
        zMin = 0F;
        break;
      case EAST:
        xMin = 0.625F;
        xMax = 1.0F;
        break;
      case WEST:
        xMax = 0.375F;
        xMin = 0F;
        break;
    }

    this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
  }

  @Override
  public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
    float xMin = 0.25F;
    float xMax = 0.75F;
    float zMin = 0.25F;
    float zMax = 0.75F;
    float yMin = 0.25F;
    float yMax = 0.625F;

    switch(state.func_177229_b(FACING)) {
      case UP:
        yMin = 0.625F;
        yMax = 1.0F;
        break;
      case SOUTH:
        zMin = 0.625F;
        zMax = 1.0F;
        break;
      case NORTH:
        zMax = 0.375F;
        zMin = 0F;
        break;
      case EAST:
        xMin = 0.625F;
        xMax = 1.0F;
        break;
      case WEST:
        xMax = 0.375F;
        xMin = 0F;
        break;
    }

    return AxisAlignedBB.func_178781_a(pos.func_177958_n() + xMin, pos.func_177956_o() + yMin, pos.func_177952_p() + zMin,
                                    pos.func_177958_n() + xMax, pos.func_177956_o() + yMax, pos.func_177952_p() + zMax);
  }

  @Override
  @SideOnly(Side.CLIENT)
  public int func_149645_b() {
    return 3;
  }


  @SideOnly(Side.CLIENT)
  public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
    return true;
  }

  public boolean func_149686_d() {
    return false;
  }

  /**
   * Used to determine ambient occlusion and culling when rebuilding chunks for render
   */
  public boolean func_149662_c() {
    return false;
  }

  @Override
  public TileEntity func_149915_a(World worldIn, int meta) {
    return new TileFaucet();
  }

  /**
   * Called by ItemBlocks just before a block is actually set in the world, to allow for adjustments to the
   * IBlockstate
   */
  public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
    EnumFacing enumfacing = facing.func_176734_d();

    if(enumfacing == EnumFacing.DOWN) {
      enumfacing = placer.func_174811_aO().func_176734_d();
    }

    return this.func_176223_P().func_177226_a(FACING, enumfacing);
  }
}
