/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.block.BlockSlime;

public class BlockSlimeCongealed
extends Block {
    public BlockSlimeCongealed() {
        super(Material.sponge);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.setHardness(0.5f);
        this.slipperiness = 0.5f;
        this.disableStats();
        this.setStepSound(SLIME_SOUND);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (BlockSlime.SlimeType type : BlockSlime.SlimeType.values()) {
            list.add(new ItemStack((Block)this, 1, type.meta));
        }
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{BlockSlime.TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.fromMeta(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((BlockSlime.SlimeType)((Object)state.getValue(BlockSlime.TYPE))).meta;
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public AxisAlignedBB getCollisionBoundingBox(World worldIn, BlockPos pos, IBlockState state) {
        return AxisAlignedBB.fromBounds((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)((double)pos.getX() + 1.0), (double)((double)pos.getY() + 0.625), (double)((double)pos.getZ() + 1.0));
    }

    public void onLanded(World world, Entity entity) {
        if (!(entity instanceof EntityLiving) && !(entity instanceof EntityItem)) {
            return;
        }
        if (entity.motionY < 0.0) {
            if (entity.motionY < (double)-0.08f) {
                // empty if block
            }
            entity.motionY *= (double)-1.2f;
            if (entity instanceof EntityLiving) {
                // empty if block
            }
            if (entity instanceof EntityItem) {
                entity.onGround = false;
            }
        }
    }

    public void onFallenUpon(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.fall(fallDistance, 0.0f);
    }

    public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        int b0 = 4;
        int i = b0 + 1;
        if (worldIn.isAreaLoaded(pos.add(-i, -i, -i), pos.add(i, i, i))) {
            for (BlockPos blockpos1 : BlockPos.getAllInBox((BlockPos)pos.add(-b0, -b0, -b0), (BlockPos)pos.add(b0, b0, b0))) {
                IBlockState iblockstate1 = worldIn.getBlockState(blockpos1);
                if (!iblockstate1.getBlock().isLeaves((IBlockAccess)worldIn, blockpos1)) continue;
                iblockstate1.getBlock().beginLeavesDecay(worldIn, blockpos1);
            }
        }
    }
}

