/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerTools;

public class ModFortify
extends Modifier {
    protected final Material material;

    public ModFortify(Material material) {
        super("fortify" + material.getIdentifier());
        if (!material.hasStats("head")) {
            throw new TinkerAPIException(String.format("Trying to add a fortify-modifier for a material without tool stats: %s", material.getIdentifier()));
        }
        this.material = material;
        this.addAspects(new ModifierAspect.SingleAspect(this), new ModifierAspect.DataAspect((IModifier)this, material.materialTextColor), ModifierAspect.harvestOnly);
        ItemStack kit = TinkerTools.sharpeningKit.getItemstackWithMaterial(material);
        ItemStack flint = new ItemStack(Items.flint);
        this.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{kit, flint}));
    }

    @Override
    public String getLocalizedName() {
        return Util.translateFormatted(String.format("modifier.%s.name", "fortify"), this.material.getLocalizedName());
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translateFormatted(String.format("modifier.%s.desc", "fortify"), this.material.getLocalizedName());
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        NBTTagCompound tag = TagUtil.getToolTag(rootCompound);
        HeadMaterialStats stats = (HeadMaterialStats)this.material.getStats("head");
        tag.setInteger("HarvestLevel", stats.harvestLevel);
        NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound mod = tagList.getCompoundTagAt(i);
            ModifierNBT data = ModifierNBT.readTag(mod);
            if (data.identifier.equals(this.identifier)) break;
            if (!data.identifier.startsWith("fortify")) continue;
            tagList.removeTag(i);
            --i;
        }
        TagUtil.setModifiersTagList(rootCompound, tagList);
    }

    @Override
    public boolean hasTexturePerMaterial() {
        return true;
    }
}

