/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.HarvestLevels;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;

public class Mattock
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials_axe = ImmutableSet.of((Object)Material.wood, (Object)Material.cactus, (Object)Material.plants, (Object)Material.vine, (Object)Material.gourd);
    public static final ImmutableSet<Material> effective_materials_shovel = ImmutableSet.of((Object)Material.grass, (Object)Material.ground, (Object)Material.clay);

    public Mattock() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.axeHead), PartMaterialType.head(TinkerTools.shovelHead));
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("mattock", 0);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass == null) {
            return -1;
        }
        if (toolClass.equals("axe")) {
            return this.getAxeLevel(stack);
        }
        if (toolClass.equals("shovel")) {
            return this.getShovelLevel(stack);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials_axe.contains((Object)block.getMaterial()) || effective_materials_shovel.contains((Object)block.getMaterial());
    }

    @Override
    public float miningSpeedModifier() {
        return 0.95f;
    }

    @Override
    public float damagePotential() {
        return 0.9f;
    }

    @Override
    public float knockback() {
        return 1.1f;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        boolean ret = Items.diamond_hoe.onItemUse(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
        for (BlockPos blockPos : this.getAOEBlocks(stack, worldIn, playerIn, pos)) {
            if (ToolHelper.isBroken(stack)) break;
            ret |= Items.diamond_hoe.onItemUse(stack, playerIn, worldIn, blockPos, side, hitX, hitY, hitZ);
        }
        return ret;
    }

    @Override
    public boolean isAoeHarvestTool() {
        return false;
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    @Override
    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        String text = Util.translate("stat.mattock.axelevel.name", new Object[0]);
        info.add(String.format("%s: %s", text, HarvestLevels.getHarvestLevelName(this.getAxeLevel(stack))) + EnumChatFormatting.RESET);
        text = Util.translate("stat.mattock.shovellevel.name", new Object[0]);
        info.add(String.format("%s: %s", text, HarvestLevels.getHarvestLevelName(this.getShovelLevel(stack))) + EnumChatFormatting.RESET);
        info.addMiningSpeed();
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats axe = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats shovel = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        MattockToolNBT data = new MattockToolNBT();
        data.head(axe, shovel);
        data.handle(handle);
        data.axeLevel = axe.harvestLevel;
        data.shovelLevel = shovel.harvestLevel;
        data.attack += 3.0f;
        data.modifiers = 3;
        return data.get();
    }

    protected int getAxeLevel(ItemStack stack) {
        return new MattockToolNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)stack)).axeLevel;
    }

    protected int getShovelLevel(ItemStack stack) {
        return new MattockToolNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)stack)).shovelLevel;
    }

    public static class MattockToolNBT
    extends ToolNBT {
        private static final String TAG_AxeLevel = "HarvestLevelAxe";
        private static final String TAG_ShovelLevel = "HarvestLevelShovel";
        public int axeLevel;
        public int shovelLevel;

        public MattockToolNBT() {
        }

        public MattockToolNBT(NBTTagCompound tag) {
            super(tag);
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.axeLevel = tag.getInteger(TAG_AxeLevel);
            this.shovelLevel = tag.getInteger(TAG_ShovelLevel);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.setInteger(TAG_AxeLevel, this.axeLevel);
            tag.setInteger(TAG_ShovelLevel, this.shovelLevel);
        }
    }
}

