/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.tools.client.GuiDynInventory;

public class GuiScalingChest
extends GuiDynInventory {
    protected final IInventory inventory;

    public GuiScalingChest(GuiMultiModule parent, BaseContainer container) {
        super(parent, (Container)container);
        this.inventory = (IInventory)container.getTile();
        this.slotCount = this.inventory.getSizeInventory();
        this.sliderActive = true;
    }

    @Override
    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.guiLeft = parentX + this.xOffset;
        this.guiTop = parentY + this.yOffset;
        this.columns = (this.xSize - this.slider.width) / GuiScalingChest.slot.w;
        this.rows = this.ySize / GuiScalingChest.slot.h;
        this.updateSlider();
        this.updateSlots();
    }

    @Override
    protected void updateSlider() {
        this.sliderActive = this.slotCount > this.columns * this.rows;
        super.updateSlider();
        this.slider.setEnabled(this.sliderActive);
        this.slider.show();
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.slotCount = this.inventory.getSizeInventory();
        super.update(mouseX, mouseY);
        this.updateSlider();
        this.slider.show();
        this.updateSlots();
    }

    @Override
    public boolean shouldDrawSlot(Slot slot) {
        if (slot.getSlotIndex() >= this.inventory.getSizeInventory()) {
            return false;
        }
        return super.shouldDrawSlot(slot);
    }
}

