/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class BlockTank
extends BlockEnumSmeltery<TankType> {
    public static final PropertyEnum<TankType> TYPE = PropertyEnum.create((String)"type", TankType.class);
    public static final PropertyBool KNOB = PropertyBool.create((String)"has_knob");

    public BlockTank() {
        super(TYPE, TankType.class);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)KNOB, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileTank();
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{TYPE, KNOB});
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean hasKnob = state.getValue(TYPE) == TankType.TANK && worldIn.isAirBlock(pos.up());
        return super.getActualState(state, worldIn, pos).withProperty((IProperty)KNOB, (Comparable)Boolean.valueOf(hasKnob));
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = super.getStateFromMeta(meta);
        if (meta == TankType.TANK.getMeta()) {
            state = state.withProperty((IProperty)KNOB, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.isRemote) {
            return true;
        }
        TileEntity te = worldIn.getTileEntity(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)te;
        side = side.getOpposite();
        ItemStack stack = playerIn.getHeldItem();
        if (stack == null) {
            return false;
        }
        if (FluidUtil.interactWithTank((ItemStack)stack, (EntityPlayer)playerIn, (IFluidHandler)tank, (EnumFacing)side)) {
            return true;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack) || stack.getItem() instanceof IFluidContainerItem;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileTank && stack != null && stack.hasTagCompound()) {
            ((TileTank)te).readTankFromNBT(stack.getTagCompound());
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te;
        ArrayList ret = Lists.newArrayList();
        Random rand = world instanceof World ? ((World)world).rand : RANDOM;
        Item item = this.getItemDropped(state, rand, fortune);
        ItemStack stack = null;
        if (item != null) {
            stack = new ItemStack(item, 1, this.damageDropped(state));
            ret.add(stack);
        }
        if ((te = world.getTileEntity(pos)) instanceof TileTank && stack != null && ((TileTank)te).containsFluid()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileTank)te).writeTankToNBT(tag);
            stack.setTagCompound(tag);
        }
        return ret;
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IBlockState state = world.getBlockState(pos);
        this.onBlockDestroyedByPlayer(world, pos, state);
        if (willHarvest) {
            this.harvestBlock(world, player, pos, state, world.getTileEntity(pos));
        }
        world.setBlockToAir(pos);
        return false;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.getTileEntity(pos);
        if (!(te instanceof TileTank)) {
            return 0;
        }
        TileTank tank = (TileTank)te;
        return tank.getBrightness();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer getBlockLayer() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean isFullCube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public static enum TankType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TANK,
        GAUGE,
        WINDOW;

        public final int meta = this.ordinal();

        public String getName() {
            return this.toString();
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

