/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.BlockInventory;
import slimeknights.mantle.property.PropertyString;
import slimeknights.mantle.property.PropertyUnlistedDirection;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.shared.tileentity.TileTable;

public class BlockTable
extends BlockInventory
implements ITileEntityProvider {
    public static final PropertyString TEXTURE = new PropertyString("texture");
    public static final PropertyTableItem INVENTORY = new PropertyTableItem();
    public static final PropertyUnlistedDirection FACING = new PropertyUnlistedDirection("facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockTable(Material materialIn) {
        super(materialIn);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isFullCube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer getBlockLayer() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileTable("tile.table", 0, 0);
    }

    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    protected BlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntity te = world.getTileEntity(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            return table.writeExtendedBlockState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        TileEntity te = world.getTileEntity(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            NBTTagCompound feetTag = tag.getCompoundTag("textureBlock");
            if (feetTag == null) {
                feetTag = new NBTTagCompound();
            }
            table.updateTextureBlock(feetTag);
            table.setFacing(placer.getHorizontalFacing().getOpposite());
            if (tag.hasKey("inventory")) {
                TileInventory.readInventoryFromNBT((IInventory)table, (NBTTagCompound)tag.getCompoundTag("inventory"));
            }
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        IBlockState state = world.getBlockState(pos);
        this.onBlockDestroyedByPlayer(world, pos, state);
        if (willHarvest) {
            this.harvestBlock(world, player, pos, state, world.getTileEntity(pos));
        }
        if (this.keepInventory(state) && (te = world.getTileEntity(pos)) instanceof TileInventory) {
            ((TileInventory)te).clear();
        }
        world.setBlockToAir(pos);
        return false;
    }

    protected boolean keepInventory(IBlockState state) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        TileEntity te = world.getTileEntity(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            NBTTagCompound data = table.getTextureBlock();
            for (ItemStack item : items) {
                if (item.getItem() != Item.getItemFromBlock((Block)this)) continue;
                NBTTagCompound tag = TagUtil.getTagSafe(item);
                tag.setTag("textureBlock", (NBTBase)data);
                item.setTagCompound(tag);
                if (!this.keepInventory(state)) continue;
                NBTTagCompound inventoryTag = new NBTTagCompound();
                TileInventory.writeInventoryToNBT((IInventory)table, (NBTTagCompound)inventoryTag);
                tag.setTag("inventory", (NBTBase)inventoryTag);
            }
        }
        return items;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        List<ItemStack> drops = this.getDrops((IBlockAccess)world, pos, world.getBlockState(pos), 0);
        if (drops.size() > 0) {
            return drops.get(0);
        }
        return super.getPickBlock(target, world, pos, player);
    }

    public static ItemStack createItemstack(BlockTable table, int tableMeta, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1, tableMeta);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.writeToNBT(subTag);
            tag.setTag("textureBlock", (NBTBase)subTag);
            stack.setTagCompound(tag);
        }
        return stack;
    }
}

