/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.EntityUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class FryPan
extends ToolCore {
    public FryPan() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.panHead));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems);
        ItemStack tool = this.getInfiTool("Bane of Pigs");
        if (tool != null) {
            for (int i = 0; i < 125; ++i) {
                TinkerTools.modFiery.apply(tool);
            }
            if (this.hasValidMaterials(tool)) {
                subItems.add(tool);
            }
        }
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        Vec3 look;
        if (world.field_72995_K) {
            return;
        }
        float progress = (float)(this.func_77626_a(stack) - timeLeft) / 30.0f;
        float strength = 0.1f + 1.5f * progress * progress;
        float range = 3.2f;
        Vec3 eye = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        MovingObjectPosition mop = EntityUtil.raytraceEntity((Entity)player, eye, look = player.func_70676_i(1.0f), range, true);
        if (mop == null) {
            return;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            boolean flamingStrike;
            Entity entity = mop.field_72308_g;
            double x = look.field_72450_a * (double)strength;
            double y = look.field_72448_b / 3.0 * (double)strength + (double)0.1f + (double)(0.4f * progress);
            double z = look.field_72449_c * (double)strength;
            AttributeModifier modifier = new AttributeModifier(field_111210_e, "Weapon modifier", (double)(progress * 5.0f), 0);
            boolean bl = flamingStrike = progress >= 1.0f && entity.func_70027_ad();
            if (!flamingStrike) {
                entity.func_70015_d(1);
            }
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(modifier);
            ToolHelper.attackEntity(stack, this, player, entity);
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(modifier);
            if (!flamingStrike) {
                entity.func_70066_B();
            }
            player.field_70170_p.func_72956_a((Entity)player, Sounds.frypan_boing, 1.5f, 0.6f + 0.2f * TConstruct.random.nextFloat());
            entity.func_70024_g(x, y, z);
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(entity));
            }
        }
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityPlayer player, EntityLivingBase entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit) {
            player.field_70170_p.func_72956_a((Entity)player, Sounds.frypan_boing, 1.2f, 0.8f + 0.4f * TConstruct.random.nextFloat());
        }
        return hit;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.7f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ);
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public float knockback() {
        return 2.0f;
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        return this.buildDefaultTag(materials).get();
    }
}

