/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.fluid.FluidColored;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.shared.block.BlockLiquidSlime;
import slimeknights.tconstruct.smeltery.block.BlockMolten;
import slimeknights.tconstruct.smeltery.block.BlockTinkerFluid;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="TinkerFluids", pulsesRequired="TinkerSmeltery", forced=true)
public class TinkerFluids
extends TinkerPulse {
    public static final String PulseId = "TinkerFluids";
    static final Logger log = Util.getLogger("TinkerFluids");
    @SidedProxy(clientSide="slimeknights.tconstruct.shared.FluidsClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static FluidMolten searedStone;
    public static FluidMolten obsidian;
    public static FluidMolten clay;
    public static FluidMolten dirt;
    public static FluidMolten iron;
    public static FluidMolten gold;
    public static FluidMolten pigIron;
    public static FluidMolten cobalt;
    public static FluidMolten ardite;
    public static FluidMolten manyullyn;
    public static FluidMolten knightslime;
    public static FluidMolten emerald;
    public static FluidColored blood;
    public static FluidColored milk;
    public static FluidColored blueslime;
    public static FluidColored purpleSlime;
    public static FluidMolten alubrass;
    public static FluidMolten brass;
    public static FluidMolten copper;
    public static FluidMolten tin;
    public static FluidMolten bronze;
    public static FluidMolten zinc;
    public static FluidMolten lead;
    public static FluidMolten nickel;
    public static FluidMolten silver;
    public static FluidMolten electrum;
    public static FluidMolten steel;
    public static FluidMolten aluminum;
    static List<Fluid> fluids;

    public static void setupFluids() {
        FluidRegistry.enableUniversalBucket();
        iron = TinkerFluids.fluidMetal(TinkerMaterials.iron.getIdentifier(), 11014674);
        iron.setTemperature(769);
        gold = TinkerFluids.fluidMetal("gold", 16176649);
        gold.setTemperature(532);
        gold.setRarity(EnumRarity.RARE);
        pigIron = TinkerFluids.fluidMetal(TinkerMaterials.pigiron);
        pigIron.setTemperature(600);
        pigIron.setRarity(EnumRarity.EPIC);
        cobalt = TinkerFluids.fluidMetal(TinkerMaterials.cobalt);
        cobalt.setTemperature(950);
        cobalt.setRarity(EnumRarity.RARE);
        ardite = TinkerFluids.fluidMetal(TinkerMaterials.ardite);
        ardite.setTemperature(860);
        ardite.setRarity(EnumRarity.RARE);
        manyullyn = TinkerFluids.fluidMetal(TinkerMaterials.manyullyn);
        manyullyn.setTemperature(1000);
        manyullyn.setRarity(EnumRarity.RARE);
        knightslime = TinkerFluids.fluidMetal(TinkerMaterials.knightslime);
        knightslime.setTemperature(520);
        knightslime.setRarity(EnumRarity.EPIC);
        alubrass = TinkerFluids.fluidMetal("alubrass", 15524679);
        alubrass.setTemperature(500);
        brass = TinkerFluids.fluidMetal("brass", 15590283);
        brass.setTemperature(470);
        copper = TinkerFluids.fluidMetal(TinkerMaterials.copper);
        copper.setTemperature(542);
        tin = TinkerFluids.fluidMetal("tin", 0xC1CDDC);
        tin.setTemperature(350);
        bronze = TinkerFluids.fluidMetal(TinkerMaterials.bronze);
        bronze.setTemperature(475);
        zinc = TinkerFluids.fluidMetal("zinc", 13889512);
        zinc.setTemperature(375);
        lead = TinkerFluids.fluidMetal(TinkerMaterials.lead);
        lead.setTemperature(400);
        nickel = TinkerFluids.fluidMetal("nickel", 13162115);
        nickel.setTemperature(727);
        silver = TinkerFluids.fluidMetal(TinkerMaterials.silver);
        silver.setTemperature(480);
        silver.setRarity(EnumRarity.RARE);
        electrum = TinkerFluids.fluidMetal(TinkerMaterials.electrum);
        electrum.setTemperature(500);
        electrum.setRarity(EnumRarity.EPIC);
        steel = TinkerFluids.fluidMetal(TinkerMaterials.steel);
        steel.setTemperature(681);
        aluminum = TinkerFluids.fluidMetal("aluminum", 15720661);
        aluminum.setTemperature(330);
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (TinkerFluids.isSmelteryLoaded()) {
            searedStone = TinkerFluids.fluidStone("stone", 0x777777);
            searedStone.setTemperature(800);
            TinkerFluids.registerFluid(searedStone);
            TinkerFluids.registerMoltenBlock(searedStone);
            FluidRegistry.addBucketForFluid((Fluid)searedStone);
            obsidian = TinkerFluids.fluidStone(TinkerMaterials.obsidian.getIdentifier(), 2887001);
            obsidian.setTemperature(1000);
            TinkerFluids.registerFluid(obsidian);
            TinkerFluids.registerMoltenBlock(obsidian);
            FluidRegistry.addBucketForFluid((Fluid)obsidian);
            clay = TinkerFluids.fluidStone("clay", 13005907);
            clay.setTemperature(700);
            TinkerFluids.registerFluid(clay);
            TinkerFluids.registerMoltenBlock(clay);
            FluidRegistry.addBucketForFluid((Fluid)clay);
            dirt = TinkerFluids.fluidStone("dirt", 10913124);
            dirt.setTemperature(500);
            TinkerFluids.registerFluid(dirt);
            TinkerFluids.registerMoltenBlock(dirt);
            FluidRegistry.addBucketForFluid((Fluid)dirt);
            emerald = TinkerFluids.fluidMetal("emerald", 5826446);
            emerald.setTemperature(999);
            TinkerFluids.registerFluid(emerald);
            TinkerFluids.registerMoltenBlock(emerald);
            FluidRegistry.addBucketForFluid((Fluid)emerald);
            blood = TinkerFluids.fluidClassic("blood", 0x540000);
            blood.setTemperature(420);
            TinkerFluids.registerFluid(blood);
            TinkerFluids.registerClassicBlock(blood);
            FluidRegistry.addBucketForFluid((Fluid)blood);
        }
        milk = TinkerFluids.fluidMilk("milk", 0xFFFFFF);
        milk.setTemperature(320);
        TinkerFluids.registerFluid(milk);
        TinkerFluids.registerClassicBlock(milk);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack((Fluid)milk, 1000), (ItemStack)new ItemStack(Items.field_151117_aB), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        if (TinkerFluids.isWorldLoaded()) {
            blueslime = TinkerFluids.fluidClassic("blueslime", -278400779);
            blueslime.setTemperature(310);
            blueslime.setViscosity(1500);
            blueslime.setDensity(1500);
            TinkerFluids.registerFluid(blueslime);
            TinkerFluids.registerBlock(new BlockLiquidSlime(blueslime, Material.field_151586_h), blueslime.getName());
            FluidRegistry.addBucketForFluid((Fluid)blueslime);
        }
        if (TinkerFluids.isWorldLoaded() || TinkerFluids.isSmelteryLoaded()) {
            purpleSlime = TinkerFluids.fluidClassic("purpleslime", -271436033);
            purpleSlime.setTemperature(370);
            purpleSlime.setViscosity(1600);
            purpleSlime.setDensity(1600);
            TinkerFluids.registerFluid(purpleSlime);
            TinkerFluids.registerBlock(new BlockLiquidSlime(purpleSlime, Material.field_151586_h), purpleSlime.getName());
            FluidRegistry.addBucketForFluid((Fluid)purpleSlime);
        }
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    private static FluidMolten fluidMetal(slimeknights.tconstruct.library.materials.Material material) {
        return TinkerFluids.fluidMetal(material.getIdentifier(), material.materialTextColor);
    }

    private static FluidMolten fluidMetal(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color);
        return fluid;
    }

    private static FluidMolten fluidLiquid(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color, FluidMolten.ICON_LiquidStill, FluidMolten.ICON_LiquidFlowing);
        TinkerFluids.registerFluid(fluid);
        return fluid;
    }

    private static FluidMolten fluidStone(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color, FluidColored.ICON_StoneStill, FluidColored.ICON_StoneFlowing);
        fluid = TinkerFluids.registerFluid(fluid);
        return fluid;
    }

    private static FluidColored fluidClassic(String name, int color) {
        FluidColored fluid = new FluidColored(name, color, FluidColored.ICON_LiquidStill, FluidColored.ICON_LiquidFlowing);
        fluid = TinkerFluids.registerFluid(fluid);
        return fluid;
    }

    private static FluidColored fluidMilk(String name, int color) {
        FluidColored fluid = new FluidColored(name, color, FluidColored.ICON_MilkStill, FluidColored.ICON_MilkFlowing);
        fluid = TinkerFluids.registerFluid(fluid);
        return fluid;
    }

    public static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName(Util.prefix(fluid.getName()));
        FluidRegistry.registerFluid(fluid);
        fluids.add(fluid);
        return fluid;
    }

    public static BlockFluidBase registerClassicBlock(Fluid fluid) {
        BlockTinkerFluid block = new BlockTinkerFluid(fluid, Material.field_151586_h);
        return (BlockFluidBase)TinkerFluids.registerBlock(block, fluid.getName());
    }

    public static BlockMolten registerMoltenBlock(Fluid fluid) {
        BlockMolten block = new BlockMolten(fluid);
        return TinkerFluids.registerBlock(block, "molten_" + fluid.getName());
    }

    static {
        fluids = Lists.newLinkedList();
        TinkerFluids.setupFluids();
    }
}

