/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.traits;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class AbstractTrait
extends Modifier
implements ITrait {
    public static final String LOC_Name = "modifier.%s.name";
    public static final String LOC_Desc = "modifier.%s.desc";
    protected final int color;

    public AbstractTrait(String identifier, EnumChatFormatting color) {
        this(identifier, Util.enumChatFormattingToColor(color));
    }

    public AbstractTrait(String identifier, int color) {
        super(Util.sanitizeLocalizationString(identifier));
        this.color = color;
        this.addAspects(new ModifierAspect.SingleAspect(this));
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getLocalizedName() {
        return Util.translate(LOC_Name, this.getIdentifier());
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translate(LOC_Desc, this.getIdentifier());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    @Override
    public void onArmorTick(ItemStack tool, World world, EntityPlayer player) {
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
    }

    @Override
    public void beforeBlockBreak(ItemStack tool, BlockEvent.BreakEvent event) {
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
    }

    @Override
    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
    }

    @Override
    public boolean isCriticalHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target) {
        return false;
    }

    @Override
    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        return newDamage;
    }

    @Override
    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
    }

    @Override
    public float knockBack(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float knockback, float newKnockback, boolean isCritical) {
        return newKnockback;
    }

    @Override
    public void onBlock(ItemStack tool, EntityPlayer player, LivingHurtEvent event) {
    }

    @Override
    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        return newDamage;
    }

    @Override
    public int onToolHeal(ItemStack tool, int amount, int newAmount, EntityLivingBase entity) {
        return newAmount;
    }

    @Override
    public void onRepair(ItemStack tool, int amount) {
    }

    public String getModifierIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        NBTTagList tagList = TagUtil.getTraitsTagList(stack);
        int index = TinkerUtil.getIndexInList(tagList, this.getIdentifier());
        return index < 0;
    }

    @Override
    public void updateNBT(NBTTagCompound modifierTag) {
        this.updateNBTforTrait(modifierTag, this.color);
    }

    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        data.identifier = this.getModifierIdentifier();
        data.color = newColor;
        if (data.level == 0) {
            data.level = 1;
        }
        data.write(modifierTag);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        NBTTagList traits = TagUtil.getTraitsTagList(rootCompound);
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            if (!this.identifier.equals(traits.func_150307_f(i))) continue;
            return;
        }
        traits.func_74742_a((NBTBase)new NBTTagString(this.identifier));
        TagUtil.setTraitsTagList(rootCompound, traits);
    }
}

