package slimeknights.tconstruct.world.entity;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockLiquidSlime;
import slimeknights.tconstruct.world.TinkerWorld;

public class EntityBlueSlime extends EntitySlime {

  public EntityBlueSlime(World worldIn) {
    super(worldIn);
  }

  // we're using this instead of getDropItem because we need the metadata
  @Override
  public EntityItem func_145778_a(Item itemIn, int size, float offsetY) {
    ItemStack stack = TinkerCommons.matSlimeBallBlue.func_77946_l();
    stack.field_77994_a = size;
    return this.func_70099_a(stack, offsetY);
  }

  @Override
  protected EntitySlime func_70802_j() {
    return new EntityBlueSlime(this.field_70170_p);
  }

  @Override
  public boolean func_70601_bi() {
    if(this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockLiquidSlime) {
      return true;
    }
    if(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == TinkerWorld.slimeGrass) {
      return true;
    }
    return false;
  }

  @Override
  protected boolean spawnCustomParticles() {
    if(this.field_70170_p.field_72995_K) {
      int i = this.func_70809_q();
      for(int j = 0; j < i * 8; ++j) {
        float f = this.field_70146_Z.nextFloat() * (float) Math.PI * 2.0F;
        float f1 = this.field_70146_Z.nextFloat() * 0.5F + 0.5F;
        float f2 = MathHelper.func_76126_a(f) * (float) i * 0.5F * f1;
        float f3 = MathHelper.func_76134_b(f) * (float) i * 0.5F * f1;
        double d0 = this.field_70165_t + (double) f2;
        double d1 = this.field_70161_v + (double) f3;
        double d2 = this.func_174813_aQ().field_72338_b;
        TinkerWorld.proxy.spawnSlimeParticle(this.field_70170_p, d0, d2, d1);
      }
    }
    return true;
  }
}
