package slimeknights.tconstruct.tools.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

import java.util.List;

import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class LongSword extends BroadSword {

  public LongSword() {
    super(PartMaterialType.handle(TinkerTools.toolRod),
          PartMaterialType.head(TinkerTools.swordBlade),
          PartMaterialType.extra(TinkerTools.handGuard));
  }

  @Override
  public float damagePotential() {
    return 1.13f;
  }

  @Override
  public int attackSpeed() {
    return 0;
  }

  @Override
  public float damageCutoff() {
    return 18f;
  }

  @Override
  public EnumAction func_77661_b(ItemStack stack) {
    return EnumAction.NONE;
  }

  @Override
  public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    // has to be done in onUpdate because onTickUsing is too early and gets overwritten. bleh.
    preventSlowDown(entityIn, 0.9f);

    super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
  }

  @Override
  public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
    int time = this.func_77626_a(stack) - timeLeft;
    if (time > 5)
    {
      player.func_71020_j(0.2F);
      player.func_70031_b(true);

      float increase = (float) (0.02 * time + 0.2);
      if (increase > 0.56f)
        increase = 0.56f;
      player.field_70181_x += increase;

      float speed = 0.05F * time;
      if (speed > 0.925f)
        speed = 0.925f;
      player.field_70159_w = (double) (-MathHelper.func_76126_a(player.field_70177_z / 180.0F * (float) Math.PI) * MathHelper.func_76134_b(player.field_70125_A / 180.0F * (float) Math.PI) * speed);
      player.field_70179_y = (double) (MathHelper.func_76134_b(player.field_70177_z / 180.0F * (float) Math.PI) * MathHelper.func_76134_b(player.field_70125_A / 180.0F * (float) Math.PI) * speed);
    }

    super.func_77615_a(stack, world, player, timeLeft);
  }

  @Override
  public NBTTagCompound buildTag(List<Material> materials) {
    ToolNBT data = buildDefaultTag(materials);
    // a bit less base damage, but it has better scaling
    data.attack += 1f;
    data.attack = Math.max(1f, data.attack);
    return data.get();
  }
}
