package slimeknights.tconstruct.smeltery.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;

import org.lwjgl.opengl.GL11;

import java.util.List;

import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;

public class SmelteryRenderer extends TileEntitySpecialRenderer<TileSmeltery> {

  @Override
  public void func_180535_a(TileSmeltery smeltery, double x, double y, double z, float partialTicks, int destroyStage) {
    if(!smeltery.isActive())
      return;

    // get liquids
    SmelteryTank tank = smeltery.getTank();

    // safety first!
    if(tank == null || smeltery.minPos == null || smeltery.maxPos == null)
      return;

    List<FluidStack> fluids = tank.getFluids();

    // calculate x/z parameters. they'll be the same for all liquids
    double x1 = smeltery.minPos.func_177958_n() - smeltery.func_174877_v().func_177958_n();
    double y1 = smeltery.minPos.func_177956_o() - smeltery.func_174877_v().func_177956_o();
    double z1 = smeltery.minPos.func_177952_p() - smeltery.func_174877_v().func_177952_p();

    double x2 = smeltery.maxPos.func_177958_n() - smeltery.func_174877_v().func_177958_n();
    double z2 = smeltery.maxPos.func_177952_p() - smeltery.func_174877_v().func_177952_p();

    // empty smeltery :(
    if(!fluids.isEmpty()) {

      BlockPos minPos = new BlockPos(x1, y1, z1);
      BlockPos maxPos = new BlockPos(x2, y1, z2);

      // calc heights, we use mB capacities and then convert it over to blockheights during rendering
      int yd = 1 + Math.max(0, smeltery.maxPos.func_177956_o() - smeltery.minPos.func_177956_o());
      // one block height = 1000 mb
      int[] heights = calcLiquidHeights(fluids, tank.getMaxCapacity(), yd * 1000 - (int)(RenderUtil.FLUID_OFFSET*2000d), 100);

      double curY = RenderUtil.FLUID_OFFSET;
      // rendering time
      for(int i = 0; i < fluids.size(); i++) {
        double h = (double) heights[i] / 1000d;
        // minpos as start instead of smeltery.pos because we want to use the lighting inside the smeltery
        RenderUtil.renderStackedFluidCuboid(fluids.get(i), x,y,z, smeltery.minPos, minPos, maxPos, curY, curY+h);
        curY += h;
      }
    }

    // render items
    int xd = 1 + smeltery.maxPos.func_177958_n() - smeltery.minPos.func_177958_n();
    int zd = 1 + smeltery.maxPos.func_177952_p() - smeltery.minPos.func_177952_p();
    int layer = xd*zd;
    //Tessellator tessellator = Tessellator.getInstance();
    //WorldRenderer renderer = tessellator.getWorldRenderer();
    //renderer.begin(GL11.GL_QUADS, DefaultVertexFormats.BLOCK);
    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
    RenderUtil.pre(x,y,z);
    GlStateManager.func_179129_p();
    GlStateManager.func_179137_b(x1, y1, z1);
    GlStateManager.func_179109_b(0.5f, 0.5f, 0.5f);

    GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);

    RenderHelper.func_74519_b();

    for(int i = 0; i < smeltery.func_70302_i_(); i++) {
      if(smeltery.isStackInSlot(i)) {
        // calculate position inside the smeltery from slot index
        int h = i / layer;
        int i2 = i % layer;
        BlockPos pos = smeltery.minPos.func_177982_a(i2 % xd, h, i2 / xd);

        int brightness = smeltery.func_145831_w().func_175626_b(pos, 0);

        ItemStack stack = smeltery.func_70301_a(i);
        boolean isItem = !(stack.func_77973_b() instanceof ItemBlock);
        OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, (float)(brightness % 0x10000) / 1f,
                                              (float)(brightness / 0x10000) / 1f);

        //GlStateManager.pushMatrix();
        GlStateManager.func_179109_b(i2 % xd, h, i2 / xd);
        GlStateManager.func_179152_a(2f, 2f, 2f);
        if(isItem) {
          GlStateManager.func_179114_b(-90, 1, 0, 0);
        }
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        model = ForgeHooksClient.handleCameraTransforms(model , ItemCameraTransforms.TransformType.NONE);
        //Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelRenderer().renderModel(smeltery.getWorld(), model, Blocks.bedrock.getDefaultState(), pos, renderer, false);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
        if(isItem) {
          GlStateManager.func_179114_b(90, 1, 0, 0);
        }
        GlStateManager.func_179152_a(0.5f, 0.5f, 0.5f);
        GlStateManager.func_179109_b(-i2 % xd, -h, -i2 / xd);
        //GlStateManager.popMatrix();
      }
    }
    RenderHelper.func_74519_b();
//    tessellator.draw();
    RenderUtil.post();
  }

  /**
   * calculate the rendering heights for all the liquids
   * @param liquids   The liquids
   * @param capacity  Max capacity of smeltery, to calculate how much height one liquid takes up
   * @param height    Maximum height, basically represents how much height full capacity is
   * @param min       Minimum amount of height for a fluid. A fluid can never have less than this value height returned
   * @return Array with heights corresponding to input-list liquids
   */
  public static int[] calcLiquidHeights (List<FluidStack> liquids, int capacity, int height, int min)
  {
    int fluidHeights[] = new int[liquids.size()];

    if(liquids.size() > 0) {

      for(int i = 0; i < liquids.size(); i++) {
        FluidStack liquid = liquids.get(i);

        float h = (float) liquid.amount / (float) capacity;
        fluidHeights[i] = Math.max(min, (int) Math.ceil(h * (float) height));
      }

      // check if we have enough height to render everything
      int sum = 0;
      do {
        sum = 0;
        int biggest = -1;
        int m = 0;
        for(int i = 0; i < fluidHeights.length; i++) {
          sum += fluidHeights[i];
          if(liquids.get(i).amount > biggest) {
            biggest = liquids.get(i).amount;
            m = i;
          }
        }

        // we can't get a result without going negative
        if(fluidHeights[m] == 0) {
          break;
        }

        // remove a pixel from the biggest one
        if(sum > height)
          fluidHeights[m]--;
      } while(sum > height);
    }

    return fluidHeights;
  }
}
