/*
 * Decompiled with CFR 0.152.
 */
package fuj1n.recmod.client.gui;

import fuj1n.recmod.RecMod;
import fuj1n.recmod.client.gui.GuiNumTextField;
import fuj1n.recmod.network.packet.PacketUpdatePlayerStatus;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiSimple
extends GuiScreen {
    public String boundPlayer;
    public int guiState = 0;
    public String[] stateNames = new String[]{this.translate("recmod.gui.pane.title.main"), this.translate("recmod.gui.pane.title.general"), this.translate("recmod.gui.pane.title.interface"), this.translate("recmod.gui.pane.title.keyboard"), this.translate("recmod.gui.pane.title.notify"), this.translate("recmod.gui.pane.title.testing")};
    public int[] returnStates = new int[]{-1337, 0, 0, 0, 0, 0};
    public int listenKeyType = -1;
    public String[] showModes = new String[]{this.translate("recmod.bobber.autoshowmode.disabled"), this.translate("recmod.bobber.autoshowmode.always"), this.translate("recmod.bobber.autoshowmode.mponly"), this.translate("recmod.bobber.autoshowmode.recstat")};
    public String[] posModes = new String[]{this.translate("recmod.bobber.posmode.topleft"), this.translate("recmod.bobber.posmode.topright"), this.translate("recmod.bobber.posmode.center"), this.translate("recmod.bobber.posmode.bottomleft"), this.translate("recmod.bobber.posmode.bottomright"), this.translate("recmod.bobber.posmode.absolute")};
    public ResourceLocation background = new ResourceLocation("recmod:textures/gui/simple.png");
    public GuiNumTextField tfAbsX;
    public GuiNumTextField tfAbsY;
    protected int xSize = 176;
    protected int ySize = 166;

    public GuiSimple(String boundPlayer) {
        this.boundPlayer = boundPlayer;
        if (this.stateNames.length != this.returnStates.length) {
            throw new IllegalStateException("The length of GuiSimple.stateNames must match GuiSimple.returnStates");
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int guiLeft = (this.width - this.xSize) / 2;
        int guiTop = (this.height - this.ySize) / 2;
        this.drawDefaultBackground();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)guiLeft, (float)guiTop, (float)0.0f);
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.translate((float)(-guiLeft), (float)(-guiTop), (float)0.0f);
        super.drawScreen(mouseX, mouseY, partialTicks);
        GlStateManager.translate((float)guiLeft, (float)guiTop, (float)0.0f);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.popMatrix();
    }

    private void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRenderer.drawString(this.translate("recmod.interface.name") + this.stateNames[this.guiState], 8, 11, 0x404040);
        switch (this.guiState) {
            case 2: {
                GlStateManager.popMatrix();
                if (this.tfAbsX != null && this.tfAbsY != null) {
                    this.tfAbsX.draw("X Position: ");
                    this.tfAbsY.draw("Y Position: ");
                }
                GlStateManager.pushMatrix();
                break;
            }
        }
    }

    private void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        this.mc.getTextureManager().bindTexture(this.background);
        this.drawTexturedModalRect(0, 0, 0, 0, this.xSize, this.ySize);
    }

    public void initGui() {
        super.initGui();
        this.createGui();
    }

    public void createGui() {
        this.buttonList.clear();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.buttonList.add(new GuiButton(this.returnStates[this.guiState] == -1337 ? -1337 : 1337 + this.returnStates[this.guiState], k + this.xSize - 25, l + 5, 20, 20, this.returnStates[this.guiState] == -1337 ? this.translate("recmod.gui.close") : this.translate("recmod.gui.back")));
        int buttonDelim = 21;
        int buttonSize = this.xSize - 16;
        int smallButtonSize = buttonSize / 2;
        switch (this.guiState) {
            case 0: {
                GuiButton bRec = new GuiButton(0, k + 8 + smallButtonSize * 0, l + 30 + buttonDelim * 0, smallButtonSize, 20, '\u00a7' + (RecMod.instance.isPlayerRecording(this.boundPlayer) ? this.translate("recmod.gui.enabledcode") : this.translate("recmod.gui.disabledcode")) + this.translate("recmod.gui.pane.main.recording"));
                GuiButton bStr = new GuiButton(1, k + 8 + smallButtonSize * 1, l + 30 + buttonDelim * 0, smallButtonSize, 20, '\u00a7' + (RecMod.instance.isPlayerStreaming(this.boundPlayer) ? this.translate("recmod.gui.enabledcode") : this.translate("recmod.gui.disabledcode")) + this.translate("recmod.gui.pane.main.streaming"));
                this.buttonList.add(bRec);
                this.buttonList.add(bStr);
                this.buttonList.add(new GuiButton(1338, k + 8, l + 30 + buttonDelim * 1, buttonSize, 20, this.stateNames[1]));
                this.buttonList.add(new GuiButton(1339, k + 8, l + 30 + buttonDelim * 2, buttonSize, 20, this.stateNames[2]));
                this.buttonList.add(new GuiButton(1340, k + 8, l + 30 + buttonDelim * 3, buttonSize, 20, this.stateNames[3]));
                GuiButton temp = new GuiButton(1341, k + 8, l + 30 + buttonDelim * 4, buttonSize, 20, this.stateNames[4]);
                temp.enabled = false;
                this.buttonList.add(temp);
                temp = new GuiButton(-1111, k + 8, l + 30 + buttonDelim * 5, buttonSize, 20, this.stateNames[5]);
                temp.enabled = false;
                this.buttonList.add(temp);
                break;
            }
            case 1: {
                this.buttonList.add(new GuiButton(5, k + 8, l + 30 + buttonDelim * 0, buttonSize, 20, this.translate("recmod.gui.pane.general.kstate").replace("$s", '\u00a7' + (RecMod.instance.keepState ? this.translate("recmod.gui.enabledcode") + this.translate("recmod.gui.enabled") : this.translate("recmod.gui.disabledcode") + this.translate("recmod.gui.disabled")))));
                break;
            }
            case 2: {
                GuiButton temp = new GuiButton(3, k + 8, l + 30 + buttonDelim * 0, buttonSize, 20, this.translate("recmod.gui.pane.interface.bobber").replace("$s", '\u00a7' + (RecMod.instance.showSelf ? this.translate("recmod.gui.enabledcode") + this.translate("recmod.gui.enabled") : this.translate("recmod.gui.disabledcode") + this.translate("recmod.gui.disabled"))));
                temp.enabled = RecMod.instance.showMode == 0;
                this.buttonList.add(temp);
                this.buttonList.add(new GuiButton(4, k + 8, l + 30 + buttonDelim * 1, buttonSize, 20, this.translate("recmod.gui.pane.interface.showMode").replace("$m", '\u00a7' + (RecMod.instance.showMode != 0 ? this.translate("recmod.gui.enabledcode") : this.translate("recmod.gui.disabledcode")) + this.showModes[RecMod.instance.showMode])));
                this.buttonList.add(new GuiButton(6, k + 8, l + 30 + buttonDelim * 2, buttonSize, 20, this.translate("recmod.gui.pane.interface.posMode").replace("$m", this.posModes[RecMod.instance.posMode])));
                if (RecMod.instance.posMode == 5) {
                    this.tfAbsX = new GuiNumTextField(this.fontRenderer, k + 8 + smallButtonSize * 1, l + 30 + buttonDelim * 3, smallButtonSize, 20, -4096, 4096, RecMod.instance.absX);
                    this.tfAbsY = new GuiNumTextField(this.fontRenderer, k + 8 + smallButtonSize * 1, l + 30 + buttonDelim * 4, smallButtonSize, 20, -2160, 2160, RecMod.instance.absY);
                    this.buttonList.add(new GuiButton(7, k + 9, l + 30 + buttonDelim * 5, buttonSize, 20, this.translate("recmod.gui.pane.interface.savePos")));
                    break;
                }
                this.tfAbsX = null;
                this.tfAbsY = null;
                break;
            }
            case 3: {
                this.buttonList.add(new GuiButton(2, k + 8, l + 30 + buttonDelim * 0, buttonSize, 20, this.translate("recmod.gui.pane.keyboard.enable").replace("$s", '\u00a7' + (RecMod.instance.enableKeys ? this.translate("recmod.gui.enabledcode") + this.translate("recmod.gui.enabled") : this.translate("recmod.gui.disabledcode") + this.translate("recmod.gui.disabled")))));
                if (!RecMod.instance.enableKeys) break;
                this.buttonList.add(new GuiButton(1594, k + 9, l + 30 + buttonDelim * 2, buttonSize, 20, (this.listenKeyType == 0 ? '\u00a7' + this.translate("recmod.gui.highlightcode") : "") + this.translate("recmod.gui.pane.keyboard.record").replace("$s", RecMod.instance.keyRec == -1337 ? this.translate("recmod.gui.disabled2") : Keyboard.getKeyName((int)RecMod.instance.keyRec))));
                this.buttonList.add(new GuiButton(1595, k + 9, l + 30 + buttonDelim * 3, buttonSize, 20, (this.listenKeyType == 1 ? '\u00a7' + this.translate("recmod.gui.highlightcode") : "") + this.translate("recmod.gui.pane.keyboard.stream").replace("$s", RecMod.instance.keyStr == -1337 ? this.translate("recmod.gui.disabled2") : Keyboard.getKeyName((int)RecMod.instance.keyStr))));
            }
        }
    }

    public void actionPerformed(GuiButton button) {
        this.listenKeyType = -1;
        if (button.id == -1337) {
            this.mc.player.closeScreen();
        }
        if (button.id >= 1594) {
            this.listenKeyType = button.id - 1594;
        } else if (button.id >= 1337) {
            this.guiState = button.id - 1337;
        } else {
            switch (button.id) {
                case 0: {
                    RecMod.instance.updatePlayerInformation(this.boundPlayer, 0, !RecMod.instance.isPlayerRecording(this.boundPlayer));
                    RecMod.packetPipeline.sendToServer(new PacketUpdatePlayerStatus(this.boundPlayer, 0, RecMod.instance.isPlayerRecording(this.boundPlayer)));
                    break;
                }
                case 1: {
                    RecMod.instance.updatePlayerInformation(this.boundPlayer, 1, !RecMod.instance.isPlayerStreaming(this.boundPlayer));
                    RecMod.packetPipeline.sendToServer(new PacketUpdatePlayerStatus(this.boundPlayer, 1, RecMod.instance.isPlayerStreaming(this.boundPlayer)));
                    break;
                }
                case 2: {
                    RecMod.instance.enableKeys = !RecMod.instance.enableKeys;
                    RecMod.instance.writeToFile();
                    break;
                }
                case 3: {
                    if (RecMod.instance.showMode != 0) break;
                    RecMod.instance.showSelf = !RecMod.instance.showSelf;
                    break;
                }
                case 4: {
                    ++RecMod.instance.showMode;
                    if (RecMod.instance.showMode >= this.showModes.length) {
                        RecMod.instance.showMode = 0;
                    }
                    RecMod.instance.writeToFile();
                    break;
                }
                case 5: {
                    RecMod.instance.keepState = !RecMod.instance.keepState;
                    RecMod.instance.writeToFile();
                    break;
                }
                case 6: {
                    ++RecMod.instance.posMode;
                    if (RecMod.instance.posMode >= this.posModes.length) {
                        RecMod.instance.posMode = 0;
                    }
                    RecMod.instance.writeToFile();
                    break;
                }
                case 7: {
                    if (this.tfAbsX == null || this.tfAbsY == null) break;
                    RecMod.instance.absX = this.tfAbsX.value();
                    RecMod.instance.absY = this.tfAbsY.value();
                    RecMod.instance.writeToFile();
                }
            }
        }
        this.createGui();
    }

    protected void keyTyped(char c, int key) {
        if (this.listenKeyType == -1 && key == 1) {
            if (this.returnStates[this.guiState] != -1337) {
                this.guiState = this.returnStates[this.guiState];
                this.createGui();
            } else {
                this.mc.player.closeScreen();
            }
        } else if (this.listenKeyType != -1) {
            switch (this.listenKeyType) {
                case 0: {
                    RecMod.instance.keyRec = key == 1 ? -1337 : key;
                    break;
                }
                case 1: {
                    RecMod.instance.keyStr = key == 1 ? -1337 : key;
                }
            }
            this.listenKeyType = -1;
            RecMod.instance.writeToFile();
            this.createGui();
        } else {
            switch (this.guiState) {
                case 2: {
                    if (this.tfAbsX == null || this.tfAbsY == null) break;
                    this.tfAbsX.keyTyped(c, key);
                    this.tfAbsY.keyTyped(c, key);
                }
            }
        }
    }

    protected void mouseClicked(int x, int y, int k) throws IOException {
        super.mouseClicked(x, y, k);
        if (this.tfAbsX != null && this.tfAbsY != null) {
            this.tfAbsX.mouseClicked(x, y);
            this.tfAbsY.mouseClicked(x, y);
        }
    }

    private String translate(String s) {
        return I18n.format((String)s, (Object[])new Object[0]);
    }
}

