/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.common.client;

import com.progwml6.natura.Natura;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.overworld.block.grass.BlockColoredGrass;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GrassColorizer
implements IResourceManagerReloadListener {
    private static int[] colorBufferBlue = new int[65536];
    private static int[] colorBufferPurple = new int[65536];
    private static final ResourceLocation LOC_GRASS_BLUE_PNG = Util.getResource("textures/colormap/bluegrasscolor.png");
    private static final ResourceLocation LOC_GRASS_ORANGE_PNG = Util.getResource("textures/colormap/orangegrasscolor.png");

    public static int getBlueGrassColor(double temperature, double humidity) {
        int i = (int)((1.0 - temperature) * 255.0);
        int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
        return colorBufferBlue[j << 8 | i];
    }

    public static int getOrangeGrassColor(double temperature, double humidity) {
        int i = (int)((1.0 - temperature) * 255.0);
        int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
        return colorBufferPurple[j << 8 | i];
    }

    public static int getGrassColorForPos(IBlockAccess blockAccess, BlockPos pos, BlockColoredGrass.GrassType type) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (BlockPos.MutableBlockPos mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1))) {
            int grassColor;
            Biome biome = blockAccess.func_180494_b((BlockPos)mutableblockpos);
            switch (type) {
                case TOPIARY: {
                    grassColor = biome.func_180627_b((BlockPos)mutableblockpos);
                    break;
                }
                case BLUEGRASS: {
                    double temp = MathHelper.func_76131_a((float)biome.func_180626_a(pos), (float)0.0f, (float)1.0f);
                    double rainfall = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                    grassColor = GrassColorizer.getBlueGrassColor(temp, rainfall);
                    break;
                }
                case AUTUMNAL: {
                    double temp = MathHelper.func_76131_a((float)biome.func_180626_a(pos), (float)0.0f, (float)1.0f);
                    double rainfall = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                    grassColor = GrassColorizer.getOrangeGrassColor(temp, rainfall);
                    break;
                }
                default: {
                    grassColor = biome.func_180627_b((BlockPos)mutableblockpos);
                }
            }
            i += (grassColor & 0xFF0000) >> 16;
            j += (grassColor & 0xFF00) >> 8;
            k += grassColor & 0xFF;
        }
        return (i / 9 & 0xFF) << 16 | (j / 9 & 0xFF) << 8 | k / 9 & 0xFF;
    }

    public static int getGrassColorStatic(BlockColoredGrass.GrassType type) {
        switch (type) {
            case TOPIARY: {
                return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
            case BLUEGRASS: {
                return GrassColorizer.getBlueGrassColor(0.5, 0.5);
            }
            case AUTUMNAL: {
                return GrassColorizer.getOrangeGrassColor(1.0, 1.0);
            }
        }
        return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        try {
            colorBufferBlue = TextureUtil.func_110986_a((IResourceManager)resourceManager, (ResourceLocation)LOC_GRASS_BLUE_PNG);
            colorBufferPurple = TextureUtil.func_110986_a((IResourceManager)resourceManager, (ResourceLocation)LOC_GRASS_ORANGE_PNG);
        }
        catch (IOException e) {
            Natura.log.error((Object)e);
        }
    }
}

