/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

@SideOnly(value=Side.CLIENT)
public class ElementImage
extends SizedBookElement {
    public ImageData image;
    public int colorMultiplier;

    public ElementImage(ImageData image) {
        this(image, 0xFFFFFF);
    }

    public ElementImage(ImageData image, int colorMultiplier) {
        this(image.x, image.y, image.width, image.height, image, colorMultiplier);
    }

    public ElementImage(int x, int y, int width, int height, ImageData image) {
        this(x, y, width, height, image, image.colorMultiplier);
    }

    public ElementImage(int x, int y, int width, int height, ImageData image, int colorMultiplier) {
        super(x, y, width, height);
        this.image = image;
        if (image.x != -1) {
            x = image.x;
        }
        if (image.y != -1) {
            y = image.y;
        }
        if (image.width != -1) {
            width = image.width;
        }
        if (image.height != -1) {
            height = image.height;
        }
        if (image.colorMultiplier != 0xFFFFFF) {
            colorMultiplier = image.colorMultiplier;
        }
        this.x = x == -1 ? 0 : x;
        this.y = y == -1 ? 0 : y;
        this.width = width;
        this.height = height;
        this.colorMultiplier = colorMultiplier;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        float r = (float)(this.colorMultiplier >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.colorMultiplier >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.colorMultiplier & 0xFF) / 255.0f;
        GlStateManager.color((float)r, (float)g, (float)b);
        if (this.image.item == null) {
            this.renderEngine.bindTexture(this.image.location);
            ElementImage.drawScaledCustomSizeModalRect((int)this.x, (int)this.y, (float)this.image.u, (float)this.image.v, (int)this.image.uw, (int)this.image.vh, (int)this.width, (int)this.height, (float)this.image.texWidth, (float)this.image.texHeight);
        } else {
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)this.width, (float)this.height, (float)1.0f);
            RenderHelper.enableGUIStandardItemLighting();
            this.mc.getRenderItem().renderItemAndEffectIntoGUI(this.image.item.getItems()[0], this.x, this.y);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.popMatrix();
        }
    }
}

