/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.IDataItem;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentError;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.BlockData;
import slimeknights.mantle.client.book.data.element.DataLocation;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.book.repository.BookRepository;

@SideOnly(value=Side.CLIENT)
public class PageData
implements IDataItem {
    private static final transient ArrayList<ValueHotswap> hotswaps = new ArrayList();
    public String name = null;
    public String type = "";
    public String data = "";
    public float scale = 1.0f;
    public transient SectionData parent;
    public transient BookRepository source;
    public transient PageContent content;

    public PageData() {
        this(false);
    }

    public PageData(boolean custom) {
        if (custom) {
            this.data = "no-load";
        }
    }

    public String translate(String string) {
        return this.parent.translate(string);
    }

    @Override
    public void load() {
        String data;
        IResource pageInfo;
        if (this.name == null) {
            this.name = "page" + this.parent.unnamedPageCounter++;
        }
        this.name = this.name.toLowerCase();
        if (!this.data.equals("no-load") && (pageInfo = this.source.getResource(this.source.getResourceLocation(this.data))) != null && !(data = this.source.resourceToString(pageInfo)).isEmpty()) {
            Class<? extends PageContent> ctype = BookLoader.getPageType(this.type);
            try {
                this.content = BookLoader.GSON.fromJson(data, ctype);
            }
            catch (Exception e) {
                this.content = new ContentError(ctype == null ? "Failed to create a page of type \"" + this.type + "\", perhaps the type is not registered?" : "Failed to create a page of type \"" + this.type + "\", perhaps the page file \"" + this.data + "\" is missing or invalid?", e);
            }
        }
        if (this.content == null) {
            try {
                this.content = BookLoader.getPageType(this.type).newInstance();
            }
            catch (IllegalAccessException | InstantiationException | NullPointerException e) {
                this.content = new ContentError("Failed to create a page of type \"" + this.type + "\", perhaps the type is not registered?");
            }
        }
        try {
            this.content.parent = this;
            this.content.load();
        }
        catch (Exception e) {
            this.content = new ContentError("Failed to load page " + this.parent.name + "." + this.name + ".", e);
            e.printStackTrace();
        }
        this.content.source = this.source;
        for (Field f : this.content.getClass().getFields()) {
            if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            try {
                if (f.get(this.content) == null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            for (ValueHotswap swap : hotswaps) {
                Object[] o;
                Class<?> c = f.getType();
                if (c.isArray() && c.getComponentType().isAssignableFrom(swap.t)) {
                    try {
                        f.setAccessible(true);
                        for (Object ob : o = (Object[])f.get(this.content)) {
                            swap.swap(this.source, ob);
                        }
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                if (!swap.t.isAssignableFrom(c)) continue;
                try {
                    f.setAccessible(true);
                    o = f.get(this.content);
                    swap.swap(this.source, o);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addSwap(Class<?> t, Class<? extends ValueHotswap> swap) {
        try {
            ValueHotswap hotswap = swap.newInstance();
            hotswap.t = t;
            hotswaps.add(hotswap);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public String getTitle() {
        String title = this.parent.parent.strings.get(this.parent.name + "." + this.name);
        return title == null ? this.name : title;
    }

    static {
        PageData.addSwap(DataLocation.class, new ValueHotswap<DataLocation>(){

            @Override
            public void swap(BookRepository source, DataLocation object) {
                object.location = object.file == "$BLOCK_ATLAS" ? TextureMap.field_110575_b : source.getResourceLocation(object.file, true);
            }
        }.getClass());
        PageData.addSwap(ItemStackData.class, new ValueHotswap<ItemStackData>(){

            @Override
            public void swap(BookRepository source, ItemStackData object) {
                object.source = source;
                object.itemListLocation = source.getResourceLocation(object.itemList);
                if (object.itemListLocation != null) {
                    object.id = "->itemList";
                }
            }
        }.getClass());
        PageData.addSwap(BlockData.class, new ValueHotswap<BlockData>(){

            @Override
            public void swap(BookRepository source, BlockData object) {
                if (object.endPos == null) {
                    object.endPos = object.pos;
                }
            }
        }.getClass());
    }

    public static abstract class ValueHotswap<T> {
        protected Class<?> t;

        public abstract void swap(BookRepository var1, T var2);
    }
}

