/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.gui.book.Textures;

@SideOnly(value=Side.CLIENT)
public class GuiArrow
extends GuiButton {
    private static final int X = 412;
    public static final int WIDTH = 18;
    public static final int HEIGHT = 10;
    public ArrowType arrowType;
    public int color;
    public int hoverColor;

    public GuiArrow(int buttonId, int x, int y, ArrowType arrowType, int color, int hoverColor) {
        super(buttonId, x, y, arrowType.w, arrowType.h, "");
        this.arrowType = arrowType;
        this.color = color;
        this.hoverColor = hoverColor;
    }

    public void drawButton(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            mc.getTextureManager().bindTexture(Textures.TEX_BOOK);
            this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int color = this.hovered ? this.hoverColor : this.color;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GlStateManager.color((float)r, (float)g, (float)b);
            Gui.drawScaledCustomSizeModalRect((int)this.xPosition, (int)this.yPosition, (float)this.arrowType.x, (float)this.arrowType.y, (int)this.width, (int)this.height, (int)this.width, (int)this.height, (float)512.0f, (float)512.0f);
            this.mouseDragged(mc, mouseX, mouseY);
        }
    }

    public static enum ArrowType {
        NEXT(412, 0),
        PREV(412, 10),
        RIGHT(412, 20),
        LEFT(412, 30),
        BACK_UP(412, 40, 18, 18);

        final int x;
        final int y;
        final int w;
        final int h;

        private ArrowType(int x, int y) {
            this(x, y, 18, 10);
        }

        private ArrowType(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

