/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.mantle.inventory.SlotWrapper;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiMultiModule
extends GuiContainer {
    private static Field NEI_Manager;
    protected List<GuiModule> modules = Lists.newArrayList();
    public int cornerX;
    public int cornerY;
    public int realWidth = -1;
    public int realHeight = -1;

    public GuiMultiModule(ContainerMultiModule container) {
        super((Container)container);
    }

    protected void addModule(GuiModule module) {
        this.modules.add(module);
    }

    public List<Rectangle> getModuleAreas() {
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>(this.modules.size());
        for (GuiModule module : this.modules) {
            areas.add(module.getArea());
        }
        return areas;
    }

    public void initGui() {
        if (this.realWidth > -1) {
            this.xSize = this.realWidth;
            this.ySize = this.realHeight;
        }
        super.initGui();
        this.cornerX = this.guiLeft;
        this.cornerY = this.guiTop;
        this.realWidth = this.xSize;
        this.realHeight = this.ySize;
        for (GuiModule module : this.modules) {
            this.updateSubmodule(module);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        for (GuiModule module : this.modules) {
            module.handleDrawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawContainerName();
        this.drawPlayerInventoryName();
        for (GuiModule module : this.modules) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
            GlStateManager.translate((float)module.guiLeft, (float)module.guiTop, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            module.handleDrawGuiContainerForegroundLayer(mouseX, mouseY);
            GlStateManager.popMatrix();
        }
    }

    protected void drawBackground(ResourceLocation background) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        this.drawTexturedModalRect(this.cornerX, this.cornerY, 0, 0, this.realWidth, this.realHeight);
    }

    protected void drawContainerName() {
        ContainerMultiModule multiContainer = (ContainerMultiModule)this.inventorySlots;
        String localizedName = multiContainer.getInventoryDisplayName();
        if (localizedName != null) {
            this.fontRendererObj.drawString(localizedName, 8, 6, 0x404040);
        }
    }

    protected void drawPlayerInventoryName() {
        String localizedName = Minecraft.getMinecraft().thePlayer.inventory.getDisplayName().getUnformattedText();
        this.fontRendererObj.drawString(localizedName, 8, this.ySize - 96 + 2, 0x404040);
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        super.setWorldAndResolution(mc, width, height);
        try {
            for (GuiModule module : this.modules) {
                module.setWorldAndResolution(mc, width, height);
                if (NEI_Manager != null) {
                    NEI_Manager.set((Object)module, NEI_Manager.get((Object)this));
                }
                this.updateSubmodule(module);
            }
        }
        catch (IllegalAccessException e) {
            Mantle.logger.error((Object)e);
        }
    }

    public void onResize(@Nonnull Minecraft mc, int width, int height) {
        super.onResize(mc, width, height);
        for (GuiModule module : this.modules) {
            module.onResize(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int oldX = this.guiLeft;
        int oldY = this.guiTop;
        int oldW = this.xSize;
        int oldH = this.ySize;
        this.guiLeft = this.cornerX;
        this.guiTop = this.cornerY;
        this.xSize = this.realWidth;
        this.ySize = this.realHeight;
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.guiLeft = oldX;
        this.guiTop = oldY;
        this.xSize = oldW;
        this.ySize = oldH;
    }

    protected boolean isPointInRegion(int left, int top, int right, int bottom, int pointX, int pointY) {
        return (pointX -= this.cornerX) >= left - 1 && pointX < left + right + 1 && (pointY -= this.cornerY) >= top - 1 && pointY < top + bottom + 1;
    }

    protected void updateSubmodule(GuiModule module) {
        module.updatePosition(this.cornerX, this.cornerY, this.realWidth, this.realHeight);
        if (module.guiLeft < this.guiLeft) {
            this.xSize += this.guiLeft - module.guiLeft;
            this.guiLeft = module.guiLeft;
        }
        if (module.guiTop < this.guiTop) {
            this.ySize += this.guiTop - module.guiTop;
            this.guiTop = module.guiTop;
        }
        if (module.guiRight() > this.guiLeft + this.xSize) {
            this.xSize = module.guiRight() - this.guiLeft;
        }
        if (module.guiBottom() > this.guiTop + this.ySize) {
            this.ySize = module.guiBottom() - this.guiTop;
        }
    }

    public void drawSlot(Slot slotIn) {
        GuiModule module = this.getModuleForSlot(slotIn.slotNumber);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof SlotWrapper) {
                slot = ((SlotWrapper)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return;
            }
        }
        if (slotIn instanceof SlotWrapper) {
            slotIn.xDisplayPosition = ((SlotWrapper)slotIn).parent.xDisplayPosition;
            slotIn.yDisplayPosition = ((SlotWrapper)slotIn).parent.yDisplayPosition;
        }
        super.drawSlot(slotIn);
    }

    public boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        GuiModule module = this.getModuleForSlot(slotIn.slotNumber);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof SlotWrapper) {
                slot = ((SlotWrapper)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return false;
            }
        }
        return super.isMouseOverSlot(slotIn, mouseX, mouseY);
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiModule module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        GuiModule module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return;
        }
        super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        GuiModule module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseReleased(mouseX, mouseY, state)) {
            return;
        }
        super.mouseReleased(mouseX, mouseY, state);
    }

    protected GuiModule getModuleForPoint(int x, int y) {
        for (GuiModule module : this.modules) {
            if (!this.isPointInRegion(module.guiLeft, module.guiTop, module.guiRight(), module.guiBottom(), x + this.cornerX, y + this.cornerY)) continue;
            return module;
        }
        return null;
    }

    protected GuiModule getModuleForSlot(int slotNumber) {
        return this.getModuleForContainer(this.getContainer().getSlotContainer(slotNumber));
    }

    protected GuiModule getModuleForContainer(Container container) {
        for (GuiModule module : this.modules) {
            if (module.inventorySlots != container) continue;
            return module;
        }
        return null;
    }

    protected ContainerMultiModule getContainer() {
        return (ContainerMultiModule)this.inventorySlots;
    }

    static {
        try {
            NEI_Manager = GuiContainer.class.getDeclaredField("manager");
        }
        catch (NoSuchFieldException e) {
            NEI_Manager = null;
        }
    }
}

