/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockConnectedTexture
extends Block {
    public static final PropertyBool CONNECTED_DOWN = PropertyBool.create((String)"connected_down");
    public static final PropertyBool CONNECTED_UP = PropertyBool.create((String)"connected_up");
    public static final PropertyBool CONNECTED_NORTH = PropertyBool.create((String)"connected_north");
    public static final PropertyBool CONNECTED_SOUTH = PropertyBool.create((String)"connected_south");
    public static final PropertyBool CONNECTED_WEST = PropertyBool.create((String)"connected_west");
    public static final PropertyBool CONNECTED_EAST = PropertyBool.create((String)"connected_east");

    public BlockConnectedTexture(Material material) {
        super(material);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)CONNECTED_DOWN, (Comparable)Boolean.FALSE).withProperty((IProperty)CONNECTED_EAST, (Comparable)Boolean.FALSE).withProperty((IProperty)CONNECTED_NORTH, (Comparable)Boolean.FALSE).withProperty((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.FALSE).withProperty((IProperty)CONNECTED_UP, (Comparable)Boolean.FALSE).withProperty((IProperty)CONNECTED_WEST, (Comparable)Boolean.FALSE));
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos position) {
        return state.withProperty((IProperty)CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.DOWN))).withProperty((IProperty)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.EAST))).withProperty((IProperty)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.NORTH))).withProperty((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.SOUTH))).withProperty((IProperty)CONNECTED_UP, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.UP))).withProperty((IProperty)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.WEST)));
    }

    @Nonnull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTED_DOWN, CONNECTED_UP, CONNECTED_NORTH, CONNECTED_SOUTH, CONNECTED_WEST, CONNECTED_EAST});
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    private boolean isSideConnectable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState original = world.getBlockState(pos);
        IBlockState connected = world.getBlockState(pos.offset(side));
        return original != null && connected != null && this.canConnect(original, connected);
    }

    protected boolean canConnect(@Nonnull IBlockState original, @Nonnull IBlockState connected) {
        return original.getBlock() == connected.getBlock();
    }
}

