/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.repository.BookRepository;

public class FileRepository
extends BookRepository {
    public final String location;

    public FileRepository(String location) {
        this.location = location;
    }

    @Override
    public List<SectionData> getSections() {
        return new ArrayList<Object>(Arrays.asList((Object[])BookLoader.GSON.fromJson(this.resourceToString(this.getResource(this.getResourceLocation("index.json"))), SectionData[].class)));
    }

    @Override
    public ResourceLocation getResourceLocation(String path, boolean safe) {
        if (path == null) {
            return safe ? new ResourceLocation("") : null;
        }
        if (!path.contains(":")) {
            String langPath = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            String defaultLangPath = "en_US";
            ResourceLocation res = new ResourceLocation(this.location + "/" + langPath + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
            res = new ResourceLocation(this.location + "/" + defaultLangPath + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
            res = new ResourceLocation(this.location + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
            return safe ? new ResourceLocation("") : null;
        }
        ResourceLocation res = new ResourceLocation(path);
        if (this.resourceExists(res)) {
            return res;
        }
        return safe ? new ResourceLocation("") : null;
    }

    @Override
    public IResource getResource(ResourceLocation loc) {
        if (loc == null) {
            return null;
        }
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean resourceExists(ResourceLocation location) {
        if (location == null) {
            return false;
        }
        try {
            Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String resourceToString(IResource resource, boolean skipCommments) {
        if (resource == null) {
            return "";
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_110527_b(), (Charset)Charsets.UTF_8).iterator();
            StringBuilder builder = new StringBuilder();
            boolean isLongComment = false;
            while (iterator.hasNext()) {
                String s = ((String)iterator.next()).trim() + "\n";
                if (skipCommments) {
                    if (isLongComment) {
                        if (!s.endsWith("*/")) continue;
                        isLongComment = false;
                        continue;
                    }
                    if (s.startsWith("/*")) {
                        isLongComment = true;
                        continue;
                    }
                    if (s.startsWith("//")) continue;
                }
                builder.append(s);
            }
            return builder.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

