/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.configurate.objectmapping;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import slimeknights.mantle.configurate.objectmapping.ObjectMapper;
import slimeknights.mantle.configurate.objectmapping.ObjectMappingException;

class GuiceObjectMapper<T>
extends ObjectMapper<T> {
    private final Injector injector;
    private final Key<T> typeKey;

    protected GuiceObjectMapper(Injector injector, Class<T> clazz) throws ObjectMappingException {
        super(clazz);
        this.injector = injector;
        this.typeKey = Key.get(clazz);
    }

    @Override
    public boolean canCreateInstances() {
        try {
            this.injector.getProvider(this.typeKey);
            return true;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    @Override
    protected T constructObject() throws ObjectMappingException {
        return (T)this.injector.getInstance(this.typeKey);
    }
}

