/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.tileentity;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import slimeknights.mantle.tileentity.MantleTileEntity;

public class TileInventory
extends MantleTileEntity
implements IInventory {
    private ItemStack[] inventory;
    protected String inventoryTitle;
    protected boolean hasCustomName;
    protected int stackSizeLimit;
    protected IItemHandlerModifiable itemHandler;

    public TileInventory(String name, int inventorySize) {
        this(name, inventorySize, 64);
    }

    public TileInventory(String name, int inventorySize, int maxStackSize) {
        this.inventory = new ItemStack[inventorySize];
        this.stackSizeLimit = maxStackSize;
        this.inventoryTitle = name;
        this.itemHandler = new InvWrapper((IInventory)this);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        return this.getStackInSlot(slot) != null;
    }

    public void resize(int size) {
        this.inventory = Arrays.copyOf(this.inventory, size);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public int getInventoryStackLimit() {
        return this.stackSizeLimit;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (slot < 0 || slot >= this.inventory.length) {
            return;
        }
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        ItemStack itemStack = this.getStackInSlot(slot);
        if (itemStack == null) {
            return null;
        }
        if (itemStack.stackSize <= quantity) {
            this.setInventorySlotContents(slot, null);
            this.markDirty();
            return itemStack;
        }
        itemStack = itemStack.splitStack(quantity);
        if (this.getStackInSlot((int)slot).stackSize == 0) {
            this.setInventorySlotContents(slot, null);
        }
        this.markDirty();
        return itemStack;
    }

    public ItemStack removeStackFromSlot(int slot) {
        ItemStack itemStack = this.getStackInSlot(slot);
        this.setInventorySlotContents(slot, null);
        return itemStack;
    }

    public boolean isItemValidForSlot(int slot, @Nonnull ItemStack itemstack) {
        return slot < this.getSizeInventory() && (this.inventory[slot] == null || itemstack.stackSize + this.inventory[slot].stackSize <= this.getInventoryStackLimit());
    }

    public void clear() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    @Nonnull
    public String getName() {
        return this.inventoryTitle;
    }

    public boolean hasCustomName() {
        return this.hasCustomName;
    }

    public void setCustomName(String customName) {
        this.hasCustomName = true;
        this.inventoryTitle = customName;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public boolean isUsableByPlayer(@Nonnull EntityPlayer entityplayer) {
        if (this.world.getTileEntity(this.pos) != this || this.world.getBlockState(this.pos).getBlock() == Blocks.AIR) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    public void openInventory(@Nonnull EntityPlayer player) {
    }

    public void closeInventory(@Nonnull EntityPlayer player) {
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.resize(tags.getInteger("InventorySize"));
        this.readInventoryFromNBT(tags);
        if (tags.hasKey("CustomName", 8)) {
            this.inventoryTitle = tags.getString("CustomName");
        }
    }

    @Nonnull
    public NBTTagCompound writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setInteger("InventorySize", this.inventory.length);
        this.writeInventoryToNBT(tags);
        if (this.hasCustomName()) {
            tags.setString("CustomName", this.inventoryTitle);
        }
        return tags;
    }

    public void writeInventoryToNBT(NBTTagCompound tag) {
        TileInventory inventory = this;
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (inventory.getStackInSlot(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setByte("Slot", (byte)i);
            inventory.getStackInSlot(i).writeToNBT(itemTag);
            nbttaglist.appendTag((NBTBase)itemTag);
        }
        tag.setTag("Items", (NBTBase)nbttaglist);
    }

    public void readInventoryFromNBT(NBTTagCompound tag) {
        TileInventory inventory = this;
        NBTTagList nbttaglist = tag.getTagList("Items", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound itemTag = nbttaglist.getCompoundTagAt(i);
            int slot = itemTag.getByte("Slot") & 0xFF;
            if (slot < 0 || slot >= inventory.getSizeInventory()) continue;
            inventory.setInventorySlotContents(slot, ItemStack.loadItemStackFromNBT((NBTTagCompound)itemTag));
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }
}

