/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnumBlock<E extends Enum<E> & IStringSerializable>
extends Block {
    public final PropertyEnum<E> prop;
    private final E[] values;
    protected static PropertyEnum<?> tmp;

    public EnumBlock(Material material, PropertyEnum<E> prop, Class<E> clazz) {
        super(EnumBlock.preInit(material, prop));
        this.prop = prop;
        this.values = (Enum[])clazz.getEnumConstants();
    }

    private static Material preInit(Material material, PropertyEnum<?> property) {
        tmp = property;
        return material;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (E type : this.values) {
            list.add(new ItemStack((Block)this, 1, ((IEnumMeta)type).getMeta()));
        }
    }

    @Nonnull
    protected BlockStateContainer createBlockState() {
        if (this.prop == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{tmp});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.prop});
    }

    @Nonnull
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(this.prop, this.fromMeta(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return ((IEnumMeta)((Object)((Enum)((Object)state.getValue(this.prop))))).getMeta();
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    protected E fromMeta(int meta) {
        if (meta < 0 || meta >= this.values.length) {
            meta = 0;
        }
        return this.values[meta];
    }

    public static interface IEnumMeta {
        public int getMeta();
    }
}

