/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.transfer.BasicRecipeTransferHandler;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import net.minecraft.inventory.Container;

public class RecipeTransferRegistry
implements IRecipeTransferRegistry {
    private final Table<Class, String, IRecipeTransferHandler> recipeTransferHandlers = HashBasedTable.create();
    private final StackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;

    public RecipeTransferRegistry(StackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
    }

    @Override
    public <C extends Container> void addRecipeTransferHandler(@Nullable Class<C> containerClass, @Nullable String recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        if (containerClass == null) {
            Log.error("Null containerClass", new NullPointerException());
            return;
        }
        if (recipeCategoryUid == null) {
            Log.error("Null recipeCategoryUid", new NullPointerException());
            return;
        }
        BasicRecipeTransferInfo<C> recipeTransferHelper = new BasicRecipeTransferInfo<C>(containerClass, recipeCategoryUid, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
        this.addRecipeTransferHandler(recipeTransferHelper);
    }

    @Override
    public <C extends Container> void addRecipeTransferHandler(@Nullable IRecipeTransferInfo<C> recipeTransferInfo) {
        if (recipeTransferInfo == null) {
            Log.error("Null recipeTransferInfo", new NullPointerException());
            return;
        }
        BasicRecipeTransferHandler<C> recipeTransferHandler = new BasicRecipeTransferHandler<C>(this.stackHelper, this.handlerHelper, recipeTransferInfo);
        this.addRecipeTransferHandler(recipeTransferHandler, recipeTransferInfo.getRecipeCategoryUid());
    }

    @Override
    @Deprecated
    public void addRecipeTransferHandler(@Nullable IRecipeTransferHandler<?> recipeTransferHandler) {
        if (recipeTransferHandler == null) {
            Log.error("Null recipeTransferHandler", new NullPointerException());
            return;
        }
        Class<?> containerClass = recipeTransferHandler.getContainerClass();
        String recipeCategoryUid = recipeTransferHandler.getRecipeCategoryUid();
        this.recipeTransferHandlers.put(containerClass, (Object)recipeCategoryUid, recipeTransferHandler);
    }

    @Override
    public void addRecipeTransferHandler(@Nullable IRecipeTransferHandler<?> recipeTransferHandler, @Nullable String recipeCategoryUid) {
        if (recipeTransferHandler == null) {
            Log.error("Null recipeTransferHandler", new NullPointerException());
            return;
        }
        if (recipeCategoryUid == null) {
            Log.error("Null recipeCategoryUid", new NullPointerException());
            return;
        }
        Class<?> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, (Object)recipeCategoryUid, recipeTransferHandler);
    }

    @Override
    public void addUniversalRecipeTransferHandler(@Nullable IRecipeTransferHandler<?> recipeTransferHandler) {
        if (recipeTransferHandler == null) {
            Log.error("Null recipeTransferHandler", new NullPointerException());
            return;
        }
        Class<?> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, (Object)"universal recipe transfer handler", recipeTransferHandler);
    }

    public ImmutableTable<Class, String, IRecipeTransferHandler> getRecipeTransferHandlers() {
        return ImmutableTable.copyOf(this.recipeTransferHandlers);
    }
}

