/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RecipesGui
extends Screen
implements IRecipesGui,
IShowsRecipeFocuses,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final RecipeTransferManager recipeTransferManager;
    private final IClientConfig clientConfig;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private ITextComponent title = StringTextComponent.EMPTY;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final HoverChecker titleHoverChecker = new HoverChecker();
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private Screen parentScreen;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);
    private Rectangle2d titleArea = new Rectangle2d(0, 0, 0, 0);
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, RecipeTransferManager recipeTransferManager, IngredientManager ingredientManager, IModIdHelper modIdHelper, IClientConfig clientConfig) {
        super((ITextComponent)new StringTextComponent("Recipes"));
        this.recipeTransferManager = recipeTransferManager;
        this.clientConfig = clientConfig;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, ingredientManager, modIdHelper);
        this.recipeCatalysts = new RecipeCatalysts();
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic);
        this.minecraft = Minecraft.getInstance();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getGuiBackground();
    }

    private static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer font, String string, Rectangle2d area) {
        Rectangle2d textArea = MathUtil.centerTextArea(area, font, string);
        font.drawShadow(matrixStack, string, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    private static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer font, ITextComponent text, Rectangle2d area) {
        Rectangle2d textArea = MathUtil.centerTextArea(area, font, (ITextProperties)text);
        font.drawShadow(matrixStack, text, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        int xSize = 198;
        int ySize = this.height - 68;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (width - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = new Rectangle2d(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        this.font.getClass();
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.x = rightButtonX;
        this.nextRecipeCategory.y = recipeClassButtonTop;
        this.previousRecipeCategory.x = leftButtonX;
        this.previousRecipeCategory.y = recipeClassButtonTop;
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.x = rightButtonX;
        this.nextPage.y = pageButtonTop;
        this.previousPage.x = leftButtonX;
        this.previousPage.y = pageButtonTop;
        this.headerHeight = pageButtonTop + 13 - guiTop;
        int titleX = this.previousRecipeCategory.x + this.previousRecipeCategory.getWidth();
        this.titleArea = new Rectangle2dBuilder(titleX, recipeClassButtonTop, this.nextRecipeCategory.x - titleX, titleHeight).insetByPadding(14).build();
        this.addButtons();
        this.init = true;
        this.updateLayout();
    }

    private void addButtons() {
        this.addButton((Widget)this.nextRecipeCategory);
        this.addButton((Widget)this.nextRecipeCategory);
        this.addButton((Widget)this.previousRecipeCategory);
        this.addButton((Widget)this.nextPage);
        this.addButton((Widget)this.previousPage);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        this.renderBackground(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        this.background.draw(matrixStack, x, y, width, height);
        RenderSystem.disableBlend();
        RecipesGui.fill((MatrixStack)matrixStack, (int)(x + 6 + 13), (int)this.nextRecipeCategory.y, (int)(x + width - 6 - 13), (int)(this.nextRecipeCategory.y + 13), (int)0x30000000);
        RecipesGui.fill((MatrixStack)matrixStack, (int)(x + 6 + 13), (int)this.nextPage.y, (int)(x + width - 6 - 13), (int)(this.nextPage.y + 13), (int)0x30000000);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(matrixStack, this.font, this.title, this.titleArea);
        Rectangle2d pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(matrixStack, this.font, this.pageString, pageArea);
        this.nextRecipeCategory.render(matrixStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.render(matrixStack, mouseX, mouseY, partialTicks);
        this.nextPage.render(matrixStack, mouseX, mouseY, partialTicks);
        this.previousPage.render(matrixStack, mouseX, mouseY, partialTicks);
        RecipeLayout<?> hoveredLayout = null;
        for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(matrixStack, mouseX, mouseY);
        }
        GuiIngredient<?> hoveredRecipeCatalyst = this.recipeCatalysts.draw(matrixStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.minecraft, matrixStack, mouseX, mouseY);
        if (hoveredLayout != null) {
            hoveredLayout.drawOverlays(matrixStack, mouseX, mouseY);
        }
        if (hoveredRecipeCatalyst != null) {
            hoveredRecipeCatalyst.drawOverlays(matrixStack, 0, 0, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            TranslationTextComponent showAllRecipesString = new TranslationTextComponent("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText((ITextProperties)showAllRecipesString, mouseX, mouseY, matrixStack);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.minecraft != null && this.minecraft.screen == this) {
            if (MathUtil.contains(this.area, mouseX, mouseY)) {
                return true;
            }
            for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            IClickedIngredient<?> clicked = this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                return clicked;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                for (RecipeLayout<?> recipeLayouts : this.recipeLayouts) {
                    Object displayedIngredient;
                    GuiIngredient<?> clicked2 = recipeLayouts.getGuiIngredientUnderMouse(mouseX, mouseY);
                    if (clicked2 == null || (displayedIngredient = clicked2.getDisplayedIngredient()) == null) continue;
                    return ClickedIngredient.create(displayedIngredient, clicked2.getRect());
                }
            }
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public boolean mouseScrolled(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.isMouseOver(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.mouseScrolled(scrollX, scrollY, scrollDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        IMouseHandler mouseHandler;
        IMouseHandler mouseHandled;
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (RecipeLayout<?> recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleClick(mouseX, mouseY, mouseButton)) continue;
                    return true;
                }
            }
        }
        if ((mouseHandled = (mouseHandler = this.recipeGuiTabs.getMouseHandler()).handleClick(this, mouseX, mouseY, mouseButton, MouseClickState.VANILLA)) != null) {
            return true;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.getOrCreate(mouseButton);
        if (this.handleKeybindings(input)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.getKey((int)keyCode, (int)scanCode);
        return this.handleKeybindings(input);
    }

    private boolean handleKeybindings(InputMappings.Input input) {
        IngredientListOverlay itemListOverlay;
        if (KeyBindings.isInventoryCloseKey(input) || KeyBindings.isInventoryToggleKey(input)) {
            this.onClose();
            return true;
        }
        if (KeyBindings.recipeBack.isActiveAndMatches(input)) {
            this.back();
            return true;
        }
        if (KeyBindings.nextCategory.isActiveAndMatches(input)) {
            this.logic.nextRecipeCategory();
            return true;
        }
        if (KeyBindings.previousCategory.isActiveAndMatches(input)) {
            this.logic.previousRecipeCategory();
            return true;
        }
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null && !(itemListOverlay = runtime.getIngredientListOverlay()).isMouseOver(MouseUtil.getX(), MouseUtil.getY())) {
            if (KeyBindings.nextPage.isActiveAndMatches(input)) {
                this.logic.nextPage();
                return true;
            }
            if (KeyBindings.previousPage.isActiveAndMatches(input)) {
                this.logic.previousPage();
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return this.minecraft != null && this.minecraft.screen == this;
    }

    private void open() {
        if (this.minecraft != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.minecraft.screen;
            }
            this.minecraft.setScreen((Screen)this);
        }
    }

    public void onClose() {
        if (this.isOpen() && this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.onClose();
    }

    @Override
    public <V> void show(IFocus<V> focus) {
        Focus<V> checkedFocus = Focus.check(focus);
        if (this.logic.setFocus(checkedFocus)) {
            this.open();
        }
    }

    @Override
    public void showCategories(List<ResourceLocation> recipeCategoryUids) {
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IClickedIngredient<?> ingredient = this.getIngredientUnderMouse(MouseUtil.getX(), MouseUtil.getY());
        if (ingredient != null) {
            return ingredient.getValue();
        }
        return null;
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        int heightPerRecipe;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        int availableHeight = height - this.headerHeight;
        int recipesPerPage = availableHeight / (heightPerRecipe = recipeBackground.getHeight() + 14);
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        int recipeXOffset = x + (width - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = StringUtil.stripStyling(recipeCategory.getTitleAsTextComponent());
        int availableTitleWidth = this.titleArea.getWidth();
        if (this.font.width((ITextProperties)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.font);
        }
        Rectangle2d titleStringArea = MathUtil.centerTextArea(this.titleArea, this.font, (ITextProperties)this.title);
        this.titleHoverChecker.updateBounds(titleStringArea);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, y + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.active = this.previousPage.active = this.logic.hasMultiplePages();
        this.nextRecipeCategory.active = this.previousRecipeCategory.active = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<Object> recipeCatalysts = this.logic.getRecipeCatalysts();
        this.recipeCatalysts.updateLayout(recipeCatalysts, this);
        this.recipeGuiTabs.initLayout(this);
    }

    private void addRecipeTransferButtons(List<RecipeLayout<?>> recipeLayouts) {
        this.children.removeAll(this.buttons);
        this.buttons.clear();
        this.addButtons();
        if (this.minecraft == null) {
            return;
        }
        ClientPlayerEntity player = this.minecraft.player;
        if (player == null) {
            return;
        }
        Container container = this.getParentContainer();
        for (RecipeLayout<?> recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            if (button == null) continue;
            button.init(this.recipeTransferManager, container, (PlayerEntity)player);
            button.setOnClickHandler((arg_0, arg_1) -> this.lambda$addRecipeTransferButtons$4(container, recipeLayout, (PlayerEntity)player, arg_0, arg_1));
            this.addButton((Widget)button);
        }
    }

    @Nullable
    private Container getParentContainer() {
        if (this.parentScreen instanceof ContainerScreen) {
            return ((ContainerScreen)this.parentScreen).getMenu();
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$4(Container container, RecipeLayout recipeLayout, PlayerEntity player, double mouseX, double mouseY) {
        boolean maxTransfer = Screen.hasShiftDown();
        if (container != null && RecipeTransferUtil.transferRecipe(this.recipeTransferManager, container, recipeLayout, player, maxTransfer)) {
            this.onClose();
        }
    }
}

