/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackFastRenderer
extends IngredientListElementRenderer<ItemStack> {
    public ItemStackFastRenderer(IIngredientListElement<ItemStack> itemStackElement) {
        super(itemStackElement);
    }

    public void renderItemAndEffectIntoGUI(IRenderTypeBuffer buffer, MatrixStack matrixStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        try {
            this.uncheckedRenderItemAndEffectIntoGUI(buffer, matrixStack, editModeConfig, worldConfig);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    @Nullable
    private IBakedModel getBakedModel() {
        ItemModelMesher itemModelMesher = Minecraft.getInstance().getItemRenderer().getItemModelShaper();
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = itemModelMesher.getItemModel(itemStack);
        return bakedModel.getOverrides().resolve(bakedModel, itemStack, null, null);
    }

    private void uncheckedRenderItemAndEffectIntoGUI(IRenderTypeBuffer buffer, MatrixStack matrixStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(matrixStack, this.area, this.padding, editModeConfig);
            RenderSystem.enableBlend();
        }
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = this.getBakedModel();
        if (bakedModel == null) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate((double)(this.area.getX() + this.padding + 16), (double)(this.area.getY() + this.padding), 150.0);
        matrixStack.scale(16.0f, -16.0f, 16.0f);
        matrixStack.translate(-0.5, -0.5, -0.5);
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        itemRenderer.render(itemStack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        matrixStack.popPose();
    }

    public void renderOverlay() {
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        try {
            this.renderOverlay(itemStack, this.area, this.padding);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    private void renderOverlay(ItemStack itemStack, Rectangle2d area, int padding) {
        FontRenderer font = ItemStackFastRenderer.getFontRenderer(itemStack);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderGuiItemDecorations(font, itemStack, area.getX() + padding, area.getY() + padding, null);
    }

    public static FontRenderer getFontRenderer(ItemStack itemStack) {
        Item item = itemStack.getItem();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.getInstance().font;
        }
        return fontRenderer;
    }
}

