/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.ingredients.IngredientSortStage;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.LogManager;

public final class IngredientSorter
implements IIngredientSorter {
    static final Double notQuiteZero = 9.765625E-4;
    private static final Comparator<IIngredientListElementInfo<?>> CREATIVE_MENU = Comparator.comparingInt(o -> {
        IIngredientListElement element = o.getElement();
        return element.getOrderIndex();
    });
    private static final Comparator<IIngredientListElementInfo<?>> PRE_SORTED = Comparator.comparing(IIngredientListElementInfo::getSortedIndex);
    private static final Comparator<IIngredientListElementInfo<?>> ALPHABETICAL = Comparator.comparing(IIngredientListElementInfo::getName);
    private final IClientConfig clientConfig;
    private final ModNameSortingConfig modNameSortingConfig;
    private final IngredientTypeSortingConfig ingredientTypeSortingConfig;
    private boolean isCacheValid;
    private static Boolean nullToolClassWarned = false;

    public IngredientSorter(IClientConfig clientConfig, ModNameSortingConfig modNameSortingConfig, IngredientTypeSortingConfig ingredientTypeSortingConfig) {
        this.clientConfig = clientConfig;
        this.modNameSortingConfig = modNameSortingConfig;
        this.ingredientTypeSortingConfig = ingredientTypeSortingConfig;
        this.isCacheValid = false;
    }

    @Override
    public void doPreSort(IngredientFilter ingredientFilter, IIngredientManager ingredientManager) {
        Set<String> modNames = ingredientFilter.getModNamesForSorting();
        Collection<IIngredientType<?>> ingredientTypes = ingredientManager.getRegisteredIngredientTypes();
        Comparator<IIngredientListElementInfo<?>> modName = this.createModNameComparator(modNames);
        Comparator<IIngredientListElementInfo<?>> ingredientType = this.createIngredientTypeComparator(ingredientTypes);
        EnumMap comparatorsForStages = new EnumMap(IngredientSortStage.class);
        comparatorsForStages.put(IngredientSortStage.ALPHABETICAL, ALPHABETICAL);
        comparatorsForStages.put(IngredientSortStage.CREATIVE_MENU, CREATIVE_MENU);
        comparatorsForStages.put(IngredientSortStage.INGREDIENT_TYPE, ingredientType);
        comparatorsForStages.put(IngredientSortStage.MOD_NAME, modName);
        comparatorsForStages.put(IngredientSortStage.TOOL_TYPE, this.createToolsComparator());
        comparatorsForStages.put(IngredientSortStage.TAG, this.createTagComparator());
        comparatorsForStages.put(IngredientSortStage.WEAPON_DAMAGE, this.createAttackComparator());
        comparatorsForStages.put(IngredientSortStage.ARMOR, this.createArmorComparator());
        comparatorsForStages.put(IngredientSortStage.MAX_DURABILITY, this.createMaxDurabilityComparator());
        List<IngredientSortStage> ingredientSorterStages = this.clientConfig.getIngredientSorterStages();
        Comparator completeComparator = ingredientSorterStages.stream().map(comparatorsForStages::get).reduce(Comparator::thenComparing).orElseGet(() -> modName.thenComparing(ingredientType).thenComparing(CREATIVE_MENU));
        List<IIngredientListElementInfo<?>> results = ingredientFilter.getIngredientListPreSort(completeComparator);
        int index = 0;
        for (IIngredientListElementInfo<?> element : results) {
            element.setSortedIndex(index);
            ++index;
        }
        this.isCacheValid = true;
    }

    @Override
    public Comparator<IIngredientListElementInfo<?>> getComparator(IngredientFilter ingredientFilter, IIngredientManager ingredientManager) {
        if (!this.isCacheValid) {
            this.doPreSort(ingredientFilter, ingredientManager);
        }
        return PRE_SORTED;
    }

    private Comparator<IIngredientListElementInfo<?>> createModNameComparator(Collection<String> modNames) {
        return this.modNameSortingConfig.getComparatorFromMappedValues(modNames);
    }

    private Comparator<IIngredientListElementInfo<?>> createIngredientTypeComparator(Collection<IIngredientType<?>> ingredientTypes) {
        Set ingredientTypeStrings = ingredientTypes.stream().map(IIngredientType::getIngredientClass).map(IngredientTypeSortingConfig::getIngredientType).collect(Collectors.toSet());
        return this.ingredientTypeSortingConfig.getComparatorFromMappedValues(ingredientTypeStrings);
    }

    @Override
    public void invalidateCache() {
        this.isCacheValid = false;
    }

    private Comparator<IIngredientListElementInfo<?>> createMaxDurabilityComparator() {
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorter.getMaxDamage(IngredientSorter.getItemStack(o)));
        return maxDamage.reversed();
    }

    private Comparator<IIngredientListElementInfo<?>> createTagComparator() {
        Comparator<IIngredientListElementInfo> isTagged = Comparator.comparing(o -> IngredientSorter.hasTag(o));
        Comparator<IIngredientListElementInfo> tag = Comparator.comparing(o -> IngredientSorter.getTagForSorting(o));
        return isTagged.reversed().thenComparing(tag);
    }

    private Comparator<IIngredientListElementInfo<?>> createToolsComparator() {
        Comparator<IIngredientListElementInfo> isToolComp = Comparator.comparing(o -> IngredientSorter.isTool(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> toolType = Comparator.comparing(o -> IngredientSorter.getToolClass(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> harvestLevel = Comparator.comparing(o -> IngredientSorter.getHarvestLevel(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorter.getToolDurability(IngredientSorter.getItemStack(o)));
        return isToolComp.reversed().thenComparing(toolType).thenComparing(harvestLevel.reversed()).thenComparing(maxDamage.reversed());
    }

    private Comparator<IIngredientListElementInfo<?>> createAttackComparator() {
        Comparator<IIngredientListElementInfo> isWeaponComp = Comparator.comparing(o -> IngredientSorter.isWeapon(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> attackDamage = Comparator.comparing(o -> IngredientSorter.getAttackDamage(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> attackSpeed = Comparator.comparing(o -> IngredientSorter.getAttackSpeed(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorter.getWeaponDurability(IngredientSorter.getItemStack(o)));
        return isWeaponComp.reversed().thenComparing(attackDamage.reversed()).thenComparing(attackSpeed.reversed()).thenComparing(maxDamage.reversed());
    }

    private Comparator<IIngredientListElementInfo<?>> createArmorComparator() {
        Comparator<IIngredientListElementInfo> isArmorComp = Comparator.comparing(o -> IngredientSorter.isArmor(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> armorSlot = Comparator.comparing(o -> IngredientSorter.getArmorSlotIndex(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> armorDamage = Comparator.comparing(o -> IngredientSorter.getArmorDamageReduce(IngredientSorter.getItemStack(o)));
        Comparator<IIngredientListElementInfo> armorToughness = Comparator.comparing(o -> Float.valueOf(IngredientSorter.getArmorToughness(IngredientSorter.getItemStack(o))));
        Comparator<IIngredientListElementInfo> maxDamage = Comparator.comparing(o -> IngredientSorter.getArmorDurability(IngredientSorter.getItemStack(o)));
        return isArmorComp.reversed().thenComparing(armorSlot.reversed()).thenComparing(armorDamage.reversed()).thenComparing(armorToughness.reversed()).thenComparing(maxDamage.reversed());
    }

    private static int getMaxDamage(ItemStack itemStack) {
        int maxDamage = Integer.MAX_VALUE;
        if (itemStack != ItemStack.EMPTY) {
            maxDamage = itemStack.getMaxDamage();
        }
        return maxDamage;
    }

    private static int getHarvestLevel(ItemStack itemStack) {
        if (itemStack != ItemStack.EMPTY) {
            return itemStack.getToolTypes().size() > 0 ? itemStack.getHarvestLevel((ToolType)itemStack.getToolTypes().iterator().next(), null, null) : -1;
        }
        return -1;
    }

    private static boolean isTool(ItemStack itemStack) {
        return !IngredientSorter.getToolClass(itemStack).isEmpty();
    }

    private static int getToolDurability(ItemStack itemStack) {
        if (IngredientSorter.isTool(itemStack)) {
            return itemStack.getMaxDamage();
        }
        return 0;
    }

    private static boolean isWeapon(ItemStack itemStack) {
        return IngredientSorter.getAttackDamage(itemStack) > notQuiteZero;
    }

    private static Double getAttackDamage(ItemStack itemStack) {
        Multimap multimap;
        boolean hasDamage;
        Double attackDamage = Double.MIN_VALUE;
        if (!IngredientSorter.isTool(itemStack) && !IngredientSorter.isArmor(itemStack) && (hasDamage = (multimap = itemStack.getAttributeModifiers(EquipmentSlotType.MAINHAND)).containsKey((Object)Attributes.ATTACK_DAMAGE))) {
            Collection damageMap = multimap.get((Object)Attributes.ATTACK_DAMAGE);
            attackDamage = ((AttributeModifier)damageMap.toArray()[0]).getAmount();
        }
        return attackDamage;
    }

    private static Double getAttackSpeed(ItemStack itemStack) {
        Double attackDamage = Double.MIN_VALUE;
        Double attackSpeed = Double.MIN_VALUE;
        if (!IngredientSorter.isTool(itemStack) && !IngredientSorter.isArmor(itemStack)) {
            Collection damageMap;
            Multimap multimap = itemStack.getAttributeModifiers(EquipmentSlotType.MAINHAND);
            boolean hasDamage = multimap.containsKey((Object)Attributes.ATTACK_DAMAGE);
            boolean hasSpeed = multimap.containsKey((Object)Attributes.ATTACK_SPEED);
            if (hasDamage && (attackDamage = Double.valueOf(((AttributeModifier)(damageMap = multimap.get((Object)Attributes.ATTACK_DAMAGE)).toArray()[0]).getAmount())) > notQuiteZero && hasSpeed) {
                Collection speedMap = multimap.get((Object)Attributes.ATTACK_SPEED);
                attackSpeed = ((AttributeModifier)speedMap.toArray()[0]).getAmount();
            }
        }
        return attackSpeed;
    }

    private static int getWeaponDurability(ItemStack itemStack) {
        if (IngredientSorter.isWeapon(itemStack)) {
            return IngredientSorter.getMaxDamage(itemStack);
        }
        return 0;
    }

    private static boolean isArmor(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return item instanceof ArmorItem;
    }

    private static int getArmorSlotIndex(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getSlot().getFilterFlag();
        }
        return 0;
    }

    private static int getArmorDamageReduce(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getDefense();
        }
        return Integer.MIN_VALUE;
    }

    private static float getArmorToughness(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getToughness();
        }
        return Float.MIN_VALUE;
    }

    private static int getArmorDurability(ItemStack itemStack) {
        if (IngredientSorter.isArmor(itemStack)) {
            return IngredientSorter.getMaxDamage(itemStack);
        }
        return 0;
    }

    private static String getTagForSorting(IIngredientListElementInfo<?> elementInfo) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        Collection<ResourceLocation> tags = elementInfo.getTagIds(ingredientManager);
        String bestTag = "";
        if (tags.size() > 0) {
            int maxTagSize = Integer.MIN_VALUE;
            for (ResourceLocation tag : tags) {
                int thisTagSize;
                if (tag.toString().equals("itemfilters:check_nbt") || (thisTagSize = ItemTags.getAllTags().getTagOrEmpty(tag).getValues().size()) <= maxTagSize) continue;
                bestTag = tag.getPath();
                maxTagSize = thisTagSize;
            }
        }
        return bestTag;
    }

    private static boolean hasTag(IIngredientListElementInfo<?> elementInfo) {
        return !IngredientSorter.getTagForSorting(elementInfo).isEmpty();
    }

    private static String getToolClass(ItemStack itemStack) {
        if (itemStack == null || itemStack == ItemStack.EMPTY) {
            return "";
        }
        Item item = itemStack.getItem();
        Set toolTypeSet = item.getToolTypes(itemStack);
        HashSet<String> toolClassSet = new HashSet<String>();
        for (ToolType toolClass : toolTypeSet) {
            if (toolClass == null) {
                if (nullToolClassWarned.booleanValue()) continue;
                nullToolClassWarned = true;
                LogManager.getLogger().warn("Item '" + item.getRegistryName() + "' has a null tool class entry.");
                continue;
            }
            if (toolClass.getName() == "sword") continue;
            toolClassSet.add(toolClass.getName());
        }
        if (toolClassSet.isEmpty()) {
            if (item instanceof HoeItem) {
                return "hoe";
            }
            if (item instanceof ShearsItem) {
                return "shears";
            }
            if (item instanceof FishingRodItem) {
                return "fishingrod";
            }
            return "";
        }
        if (toolClassSet.size() == 1) {
            return (String)toolClassSet.toArray()[0];
        }
        String[] prefOrder = new String[]{"pickaxe", "axe", "shovel", "hoe", "shears", "wrench"};
        for (int i = 0; i < prefOrder.length; ++i) {
            if (!toolClassSet.contains(prefOrder[i])) continue;
            return prefOrder[i];
        }
        return (String)toolClassSet.toArray()[0];
    }

    public static <V> ItemStack getItemStack(IIngredientListElementInfo<V> ingredientInfo) {
        IIngredientListElement<V> element = ingredientInfo.getElement();
        V ingredient = element.getIngredient();
        if (ingredient instanceof ItemStack) {
            return (ItemStack)ingredient;
        }
        return ItemStack.EMPTY;
    }
}

