/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.GuiFluidStackGroup;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiIngredientGroup;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.ShapelessIcon;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeLayout<T>
implements IRecipeLayoutDrawable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int HIGHLIGHT_COLOR = Integer.MAX_VALUE;
    private static final int RECIPE_BUTTON_SIZE = 13;
    private static final int RECIPE_BORDER_PADDING = 4;
    private final int ingredientCycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
    private final IRecipeCategory<T> recipeCategory;
    private final GuiItemStackGroup guiItemStackGroup;
    private final GuiFluidStackGroup guiFluidStackGroup;
    private final Map<IIngredientType<?>, GuiIngredientGroup<?>> guiIngredientGroups;
    @Nullable
    private final RecipeTransferButton recipeTransferButton;
    private final T recipe;
    @Nullable
    private final Focus<?> focus;
    @Nullable
    private ShapelessIcon shapelessIcon;
    private final DrawableNineSliceTexture recipeBorder;
    private int posX;
    private int posY;

    @Nullable
    public static <T> RecipeLayout<T> create(int index, IRecipeCategory<T> recipeCategory, T recipe, @Nullable Focus<?> focus, IModIdHelper modIdHelper, int posX, int posY) {
        RecipeLayout<T> recipeLayout = new RecipeLayout<T>(index, recipeCategory, recipe, focus, posX, posY);
        try {
            Ingredients ingredients = new Ingredients();
            recipeCategory.setIngredients(recipe, ingredients);
            recipeCategory.setRecipe(recipeLayout, recipe, ingredients);
            if (recipe instanceof IRecipe) {
                RecipeLayout.addOutputSlotTooltip(recipeLayout, (IRecipe)recipe, modIdHelper);
            }
            return recipeLayout;
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", (Object)recipeCategory.getClass().getCanonicalName(), (Object)e);
            return null;
        }
    }

    private static void addOutputSlotTooltip(RecipeLayout<?> recipeLayout, IRecipe<?> recipe, IModIdHelper modIdHelper) {
        ResourceLocation recipeName = recipe.getId();
        for (GuiIngredientGroup<?> ingredientGroup : recipeLayout.guiIngredientGroups.values()) {
            RecipeLayout.addOutputSlotTooltip(ingredientGroup, recipeName, modIdHelper);
        }
    }

    private static <T> void addOutputSlotTooltip(GuiIngredientGroup<T> guiIngredientGroup, ResourceLocation recipeName, IModIdHelper modIdHelper) {
        guiIngredientGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (guiIngredientGroup.getOutputSlots().contains(slotIndex)) {
                boolean showAdvanced;
                String ingredientModId;
                String recipeModId;
                if (modIdHelper.isDisplayingModNameEnabled() && !(recipeModId = recipeName.getNamespace()).equals(ingredientModId = guiIngredientGroup.getIngredientModId(ingredient))) {
                    String modName = modIdHelper.getFormattedModNameForModId(recipeModId);
                    TranslationTextComponent recipeBy = new TranslationTextComponent("jei.tooltip.recipe.by", new Object[]{modName});
                    tooltip.add(recipeBy.withStyle(TextFormatting.GRAY));
                }
                boolean bl = showAdvanced = Minecraft.getInstance().options.advancedItemTooltips || Screen.hasShiftDown();
                if (showAdvanced) {
                    TranslationTextComponent recipeId = new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{recipeName.toString()});
                    tooltip.add(recipeId.withStyle(TextFormatting.DARK_GRAY));
                }
            }
        });
    }

    private RecipeLayout(int index, IRecipeCategory<T> recipeCategory, T recipe, @Nullable Focus<?> focus, int posX, int posY) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipe, "recipe");
        this.recipeCategory = recipeCategory;
        this.focus = focus;
        Focus<ItemStack> itemStackFocus = Focus.cast(focus, VanillaTypes.ITEM);
        Focus<FluidStack> fluidStackFocus = Focus.cast(focus, VanillaTypes.FLUID);
        this.guiItemStackGroup = new GuiItemStackGroup(itemStackFocus, this.ingredientCycleOffset);
        this.guiFluidStackGroup = new GuiFluidStackGroup(fluidStackFocus, this.ingredientCycleOffset);
        this.guiIngredientGroups = new IdentityHashMap();
        this.guiIngredientGroups.put(VanillaTypes.ITEM, this.guiItemStackGroup);
        this.guiIngredientGroups.put(VanillaTypes.FLUID, this.guiFluidStackGroup);
        if (index >= 0) {
            IDrawableStatic icon = Internal.getTextures().getRecipeTransfer();
            this.recipeTransferButton = new RecipeTransferButton(0, 0, 13, 13, (IDrawable)icon, this);
        } else {
            this.recipeTransferButton = null;
        }
        this.setPosition(posX, posY);
        this.recipe = recipe;
        this.recipeBorder = Internal.getTextures().getRecipeBackground();
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        if (this.recipeTransferButton != null) {
            int width = this.recipeCategory.getBackground().getWidth();
            int height = this.recipeCategory.getBackground().getHeight();
            this.recipeTransferButton.x = posX + width + 4 + 2;
            this.recipeTransferButton.y = posY + height - 13;
        }
    }

    @Override
    public void drawRecipe(MatrixStack matrixStack, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableAlphaTest();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        matrixStack.pushPose();
        matrixStack.translate((double)this.posX, (double)this.posY, 0.0);
        IDrawable categoryBackground = this.recipeCategory.getBackground();
        int n = categoryBackground.getWidth() + 8;
        int height = categoryBackground.getHeight() + 8;
        this.recipeBorder.draw(matrixStack, -4, -4, n, height);
        background.draw(matrixStack);
        this.recipeCategory.draw(this.recipe, matrixStack, recipeMouseX, recipeMouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(matrixStack, background.getWidth());
        }
        matrixStack.popPose();
        for (GuiIngredientGroup guiIngredientGroup : this.guiIngredientGroups.values()) {
            guiIngredientGroup.draw(matrixStack, this.posX, this.posY, Integer.MAX_VALUE, mouseX, mouseY);
        }
        if (this.recipeTransferButton != null) {
            Minecraft minecraft = Minecraft.getInstance();
            float f = minecraft.getFrameTime();
            this.recipeTransferButton.render(matrixStack, mouseX, mouseY, f);
        }
        RenderSystem.disableBlend();
        RenderSystem.disableLighting();
        RenderSystem.disableAlphaTest();
    }

    @Override
    public void drawOverlays(MatrixStack matrixStack, int mouseX, int mouseY) {
        GuiIngredientGroup<?> guiIngredientGroup;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableAlphaTest();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        GuiIngredient<?> hoveredIngredient = null;
        Iterator<GuiIngredientGroup<?>> iterator = this.guiIngredientGroups.values().iterator();
        while (iterator.hasNext() && (hoveredIngredient = (guiIngredientGroup = iterator.next()).getHoveredIngredient(this.posX, this.posY, mouseX, mouseY)) == null) {
        }
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.drawToolTip(matrixStack, mouseX, mouseY);
        }
        RenderSystem.disableBlend();
        RenderSystem.disableLighting();
        if (hoveredIngredient != null) {
            hoveredIngredient.drawOverlays(matrixStack, this.posX, this.posY, recipeMouseX, recipeMouseY);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            List<ITextComponent> tooltipStrings = this.recipeCategory.getTooltipStrings(this.recipe, recipeMouseX, recipeMouseY);
            if (tooltipStrings.isEmpty() && this.shapelessIcon != null) {
                tooltipStrings = this.shapelessIcon.getTooltipStrings(recipeMouseX, recipeMouseY);
            }
            if (tooltipStrings != null && !tooltipStrings.isEmpty()) {
                TooltipRenderer.drawHoveringText(tooltipStrings, mouseX, mouseY, matrixStack);
            }
        }
        RenderSystem.disableAlphaTest();
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        Rectangle2d backgroundRect = new Rectangle2d(this.posX, this.posY, background.getWidth(), background.getHeight());
        return MathUtil.contains(backgroundRect, mouseX, mouseY) || this.recipeTransferButton != null && this.recipeTransferButton.isMouseOver(mouseX, mouseY);
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        GuiIngredient<?> guiIngredient = this.getGuiIngredientUnderMouse(mouseX, mouseY);
        if (guiIngredient != null) {
            return guiIngredient.getDisplayedIngredient();
        }
        return null;
    }

    @Nullable
    public GuiIngredient<?> getGuiIngredientUnderMouse(double mouseX, double mouseY) {
        for (GuiIngredientGroup<?> guiIngredientGroup : this.guiIngredientGroups.values()) {
            GuiIngredient<?> clicked = guiIngredientGroup.getHoveredIngredient(this.posX, this.posY, mouseX, mouseY);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    public boolean handleClick(double mouseX, double mouseY, int mouseButton) {
        return this.recipeCategory.handleClick(this.recipe, mouseX - (double)this.posX, mouseY - (double)this.posY, mouseButton);
    }

    @Override
    public GuiItemStackGroup getItemStacks() {
        return this.guiItemStackGroup;
    }

    @Override
    public IGuiFluidStackGroup getFluidStacks() {
        return this.guiFluidStackGroup;
    }

    public <V> IGuiIngredientGroup<V> getIngredientsGroup(IIngredientType<V> ingredientType) {
        GuiIngredientGroup<Object> guiIngredientGroup = this.guiIngredientGroups.get(ingredientType);
        if (guiIngredientGroup == null) {
            IFocus focus = this.getFocus((IIngredientType)ingredientType);
            guiIngredientGroup = new GuiIngredientGroup<V>(ingredientType, focus, this.ingredientCycleOffset);
            this.guiIngredientGroups.put(ingredientType, guiIngredientGroup);
        }
        return guiIngredientGroup;
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.x = posX + this.posX;
            this.recipeTransferButton.y = posY + this.posY;
        }
    }

    @Override
    public void setShapeless() {
        this.shapelessIcon = new ShapelessIcon();
    }

    @Nullable
    public Focus<?> getFocus() {
        return this.focus;
    }

    @Nullable
    public <V> Focus<V> getFocus(IIngredientType<V> ingredientType) {
        return Focus.cast(this.focus, ingredientType);
    }

    @Nullable
    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    @Override
    public IRecipeCategory<?> getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public T getRecipe() {
        return this.recipe;
    }
}

