/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.color.MMCQ;
import net.minecraft.client.renderer.texture.NativeImage;

public class ColorThief {
    @Nullable
    public static int[][] getPalette(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount, quality, ignoreWhite);
        if (cmap == null) {
            return null;
        }
        return cmap.palette();
    }

    @Nullable
    public static MMCQ.CMap getColorMap(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        if (sourceImage.func_211678_c() == NativeImage.PixelFormat.RGBA) {
            int[][] pixelArray = ColorThief.getPixels(sourceImage, quality, ignoreWhite);
            return MMCQ.quantize(pixelArray, colorCount);
        }
        return null;
    }

    private static int[][] getPixels(NativeImage sourceImage, int quality, boolean ignoreWhite) {
        int width = sourceImage.func_195702_a();
        int height = sourceImage.func_195714_b();
        int pixelCount = width * height;
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        int i = 0;
        while (i < pixelCount) {
            int x = i % width;
            int y = i / width;
            int rgba = sourceImage.func_195709_a(x, y);
            int a = rgba >> 24 & 0xFF;
            int b = rgba >> 16 & 0xFF;
            int g = rgba >> 8 & 0xFF;
            int r = rgba & 0xFF;
            if (!(a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250)) {
                pixelArray[numUsedPixels] = new int[]{r, g, b};
                ++numUsedPixels;
                i += quality;
                continue;
            }
            ++i;
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }
}

