/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.CheatMouseHandler;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.CombinedMouseHandler;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseDragHandler;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.NullMouseDragHandler;
import mezz.jei.input.NullMouseHandler;
import mezz.jei.input.ProxyMouseDragHandler;
import mezz.jei.input.ProxyMouseHandler;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Tuple;

public class IngredientListOverlay
implements IIngredientListOverlay,
IShowsRecipeFocuses {
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter searchField;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private final IMouseHandler displayedMouseHandler;
    private final IMouseHandler hiddenMouseHandler;
    private Rectangle2d displayArea = new Rectangle2d(0, 0, 0, 0);
    private boolean hasRoom;
    @Nullable
    private IGuiProperties guiProperties;

    public IngredientListOverlay(IIngredientGridSource ingredientGridSource, IngredientManager ingredientManager, GuiScreenHelper guiScreenHelper, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        ingredientGridSource.addListener(() -> this.onSetFilterText(worldConfig.getFilterText()));
        this.searchField = new GuiTextFieldFilter(ingredientGridSource, worldConfig);
        this.configButton = ConfigButton.create(this, worldConfig);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents, guiScreenHelper, ingredientManager, worldConfig);
        this.displayedMouseHandler = new CombinedMouseHandler(this.configButton.getMouseHandler(), this.contents.getMouseHandler(), new SearchMouseHandler(), new CheatMouseHandler(this, worldConfig, clientConfig));
        this.hiddenMouseHandler = this.configButton.getMouseHandler();
        this.clearKeyboardFocus();
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static Rectangle2d createDisplayArea(IGuiProperties guiProperties) {
        Rectangle2d screenRectangle = GuiProperties.getScreenRectangle(guiProperties);
        int guiRight = GuiProperties.getGuiRight(guiProperties);
        Tuple<Rectangle2d, Rectangle2d> result = MathUtil.splitX(screenRectangle, guiRight);
        Rectangle2d displayArea = (Rectangle2d)result.func_76340_b();
        return new Rectangle2dBuilder(displayArea).insetByPadding(2).build();
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean exclusionAreasChanged) {
        boolean wasDisplayed = this.isListDisplayed();
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.clearKeyboardFocus();
                this.ghostIngredientDragManager.stopDrag();
            }
        } else {
            boolean guiPropertiesChanged;
            boolean bl = guiPropertiesChanged = this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties);
            if (exclusionAreasChanged || guiPropertiesChanged) {
                this.updateNewScreen(guiProperties, guiPropertiesChanged);
            }
        }
        if (wasDisplayed && !this.isListDisplayed()) {
            this.worldConfig.saveFilterText();
        }
    }

    private void updateNewScreen(IGuiProperties guiProperties, boolean guiPropertiesChanged) {
        this.guiProperties = guiProperties;
        this.displayArea = IngredientListOverlay.createDisplayArea(guiProperties);
        if (guiPropertiesChanged) {
            this.ghostIngredientDragManager.stopDrag();
        }
        boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(this.clientConfig, guiProperties);
        Set<Rectangle2d> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
        Rectangle2d availableContentsArea = new Rectangle2dBuilder(this.displayArea).subtractHeight(searchBarCentered ? 0 : 22).build();
        this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        Rectangle2d contentsArea = this.contents.getArea();
        this.displayArea = new Rectangle2dBuilder(this.displayArea).setX(contentsArea).setWidth(contentsArea).build();
        Tuple<Rectangle2d, Rectangle2d> result = IngredientListOverlay.getSearchAndConfigArea(searchBarCentered, guiProperties, this.displayArea);
        Rectangle2d searchAndConfigArea = (Rectangle2d)result.func_76340_b();
        result = MathUtil.splitXRight(searchAndConfigArea, 20);
        Rectangle2d searchArea = (Rectangle2d)result.func_76341_a();
        Rectangle2d configButtonArea = (Rectangle2d)result.func_76340_b();
        this.searchField.updateBounds(searchArea);
        this.configButton.updateBounds(configButtonArea);
        this.updateLayout(false);
    }

    private static boolean isSearchBarCentered(IClientConfig clientConfig, IGuiProperties guiProperties) {
        return clientConfig.isCenterSearchBarEnabled() && GuiProperties.getGuiBottom(guiProperties) + 20 < guiProperties.getScreenHeight();
    }

    private static Tuple<Rectangle2d, Rectangle2d> getSearchAndConfigArea(boolean searchBarCentered, IGuiProperties guiProperties, Rectangle2d displayArea) {
        if (searchBarCentered) {
            Rectangle2d guiRectangle = GuiProperties.getGuiRectangle(guiProperties);
            Rectangle2d searchRect = new Rectangle2d(guiRectangle.func_199318_a(), displayArea.func_199317_d() - 20, guiRectangle.func_199316_c(), 20);
            return new Tuple((Object)displayArea, (Object)searchRect);
        }
        return MathUtil.splitYBottom(displayArea, 20);
    }

    public void updateLayout(boolean filterChanged) {
        this.contents.updateLayout(filterChanged);
        this.searchField.update();
    }

    public void drawScreen(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            RenderSystem.disableLighting();
            this.searchField.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            this.contents.draw(minecraft, matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.guiProperties != null) {
            this.configButton.draw(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.ghostIngredientDragManager.drawTooltips(minecraft, matrixStack, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, matrixStack, mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            this.configButton.drawTooltips(matrixStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, MatrixStack matrixStack, ContainerScreen<?> gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(-gui.getGuiLeft()), (double)(-gui.getGuiTop()), 0.0);
            this.ghostIngredientDragManager.drawOnForeground(minecraft, matrixStack, mouseX, mouseY);
            matrixStack.func_227865_b_();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.func_146178_a();
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            if (this.clientConfig.isCenterSearchBarEnabled() && this.searchField.func_231047_b_(mouseX, mouseY)) {
                return true;
            }
            return MathUtil.contains(this.displayArea, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    public IMouseHandler getMouseHandler() {
        return new ProxyMouseHandler(() -> {
            if (this.guiProperties == null) {
                return NullMouseHandler.INSTANCE;
            }
            if (this.isListDisplayed()) {
                return this.displayedMouseHandler;
            }
            return this.hiddenMouseHandler;
        });
    }

    public IMouseDragHandler getMouseDragHandler() {
        return new ProxyMouseDragHandler(() -> {
            if (this.isListDisplayed()) {
                return this.ghostIngredientDragManager.getMouseDragHandler();
            }
            return NullMouseDragHandler.INSTANCE;
        });
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.func_230999_j_();
    }

    public void clearKeyboardFocus() {
        this.setKeyboardFocus(false);
    }

    private void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.func_230996_d_(keyboardFocus);
    }

    public boolean onGlobalKeyPressed(InputMappings.Input input, MouseClickState clickState) {
        if (this.isListDisplayed()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(input)) {
                if (!clickState.isSimulate()) {
                    this.worldConfig.toggleCheatItemsEnabled();
                }
                return true;
            }
            if (KeyBindings.toggleEditMode.isActiveAndMatches(input)) {
                if (!clickState.isSimulate()) {
                    this.worldConfig.toggleEditModeEnabled();
                }
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(input)) {
                if (!clickState.isSimulate()) {
                    this.setKeyboardFocus(true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean onCharTyped(char codePoint, int modifiers) {
        if (this.isListDisplayed() && this.hasKeyboardFocus() && this.searchField.func_231042_a_(codePoint, modifiers)) {
            boolean changed = this.worldConfig.setFilterText(this.searchField.func_146179_b());
            if (changed) {
                this.updateLayout(true);
            }
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isListDisplayed()) {
            if (this.hasKeyboardFocus() && this.searchField.func_231046_a_(keyCode, scanCode, modifiers)) {
                boolean changed = this.worldConfig.setFilterText(this.searchField.func_146179_b());
                if (changed) {
                    this.updateLayout(true);
                }
                return true;
            }
            boolean pressed = this.contents.onKeyPressed(keyCode, scanCode, modifiers);
            if (pressed) {
                this.clearKeyboardFocus();
            }
            return pressed;
        }
        return false;
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IIngredientListElement<?> elementUnderMouse;
        if (this.isListDisplayed() && (elementUnderMouse = this.contents.getElementUnderMouse()) != null) {
            return elementUnderMouse.getIngredient();
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        Object ingredient = this.getIngredientUnderMouse();
        Class<T> ingredientClass = ingredientType.getIngredientClass();
        if (ingredientClass.isInstance(ingredient)) {
            return ingredientClass.cast(ingredient);
        }
        return null;
    }

    public void onSetFilterText(String filterText) {
        this.searchField.func_146180_a(filterText);
        this.updateLayout(true);
    }

    @Override
    public ImmutableList<Object> getVisibleIngredients() {
        if (this.isListDisplayed()) {
            List<IIngredientListElement<?>> visibleElements = this.contents.getVisibleElements();
            return (ImmutableList)visibleElements.stream().map(IIngredientListElement::getIngredient).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }

    private class SearchMouseHandler
    implements IMouseHandler {
        private SearchMouseHandler() {
        }

        @Override
        @Nullable
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            IMouseHandler mouseHandler = IngredientListOverlay.this.searchField.getMouseHandler();
            IMouseHandler handled = mouseHandler.handleClick(screen, mouseX, mouseY, mouseButton, clickState);
            if (handled != null) {
                if (!clickState.isSimulate()) {
                    IngredientListOverlay.this.updateLayout(true);
                }
                return this;
            }
            return null;
        }

        @Override
        public void handleMouseClickedOut(int mouseButton) {
            IngredientListOverlay.this.clearKeyboardFocus();
        }
    }
}

