/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public final class BasicRecipeTransferHandlerServer {
    private BasicRecipeTransferHandlerServer() {
    }

    public static void setItems(PlayerEntity player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        Container container = player.containerMenu;
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.getSlot(entry.getValue().intValue());
            ItemStack slotStack = slot.getItem();
            if (slotStack.isEmpty()) {
                return;
            }
            ItemStack stack = slotStack.copy();
            stack.setCount(1);
            slotMap.put(entry.getKey(), stack);
        }
        boolean transferAsCompleteSets = requireCompleteSets || !maxTransfer;
        Map<Integer, ItemStack> toTransfer = BasicRecipeTransferHandlerServer.removeItemsFromInventory(player, container, slotMap, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        if (toTransfer.isEmpty()) {
            return;
        }
        int minSlotStackLimit = Integer.MAX_VALUE;
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (int craftingSlotNumberIndex = 0; craftingSlotNumberIndex < craftingSlots.size(); ++craftingSlotNumberIndex) {
            ItemStack transferItem;
            int craftingSlotNumber = craftingSlots.get(craftingSlotNumberIndex);
            Slot craftingSlot = container.getSlot(craftingSlotNumber);
            if (!craftingSlot.mayPickup(player)) continue;
            if (craftingSlot.hasItem()) {
                ItemStack craftingItem = craftingSlot.remove(Integer.MAX_VALUE);
                clearedCraftingItems.add(craftingItem);
            }
            if (!requireCompleteSets || (transferItem = toTransfer.get(craftingSlotNumberIndex)) == null) continue;
            int slotStackLimit = craftingSlot.getMaxStackSize(transferItem);
            minSlotStackLimit = Math.min(slotStackLimit, minSlotStackLimit);
        }
        for (Map.Entry<Integer, ItemStack> entry : toTransfer.entrySet()) {
            ItemStack stack;
            Integer craftNumber = entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.getSlot(slotNumber.intValue());
            if (slot.mayPlace(stack = entry.getValue())) {
                if (stack.getCount() > minSlotStackLimit) {
                    ItemStack remainder = stack.split(stack.getCount() - minSlotStackLimit);
                    clearedCraftingItems.add(remainder);
                }
                slot.set(stack);
                continue;
            }
            clearedCraftingItems.add(stack);
        }
        for (ItemStack oldCraftingItem : clearedCraftingItems) {
            int added = BasicRecipeTransferHandlerServer.addStack(container, inventorySlots, oldCraftingItem);
            if (added >= oldCraftingItem.getCount() || player.inventory.add(oldCraftingItem)) continue;
            player.drop(oldCraftingItem, false);
        }
        container.broadcastChanges();
    }

    @Nonnull
    private static Map<Integer, ItemStack> removeItemsFromInventory(PlayerEntity player, Container container, Map<Integer, ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        HashMap<Integer, ItemStack> result;
        block8: {
            boolean noItemsFound;
            result = new HashMap<Integer, ItemStack>(required.size());
            do {
                HashMap<Slot, ItemStack> originalSlotContents = null;
                if (transferAsCompleteSets) {
                    originalSlotContents = new HashMap<Slot, ItemStack>();
                }
                HashMap<Integer, ItemStack> foundItemsInSet = new HashMap<Integer, ItemStack>(required.size());
                noItemsFound = true;
                for (Map.Entry<Integer, ItemStack> entry : required.entrySet()) {
                    boolean resultItemStackLimitReached;
                    ItemStack requiredStack = entry.getValue().copy();
                    Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                    boolean itemFound = slot != null && !slot.getItem().isEmpty() && slot.mayPickup(player);
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.getCount() == resultItemStack.getMaxStackSize();
                    if (!itemFound || resultItemStackLimitReached) {
                        if (!transferAsCompleteSets) continue;
                        for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                            ItemStack stack = (ItemStack)slotEntry.getValue();
                            ((Slot)slotEntry.getKey()).set(stack);
                        }
                        break block8;
                    }
                    if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.getItem().copy());
                    }
                    ItemStack removedItemStack = slot.remove(1);
                    foundItemsInSet.put(entry.getKey(), removedItemStack);
                    noItemsFound = false;
                }
                for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    if (resultItemStack == null) {
                        result.put(entry.getKey(), (ItemStack)entry.getValue());
                        continue;
                    }
                    resultItemStack.grow(1);
                }
            } while (maxTransfer && !noItemsFound);
        }
        return result;
    }

    @Nullable
    private static Slot getSlotWithStack(Container container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }

    private static int addStack(Container container, Collection<Integer> slotIndexes, ItemStack stack) {
        Slot slot;
        ItemStack inventoryStack;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= container.slots.size() || (inventoryStack = (slot = container.getSlot(slotIndex.intValue())).getItem()).isEmpty() || !inventoryStack.isStackable() || !inventoryStack.sameItem(stack) || !ItemStack.tagMatches((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.getCount() - added;
            int maxStackSize = Math.min(slot.getMaxStackSize(inventoryStack), inventoryStack.getMaxStackSize());
            int space = maxStackSize - inventoryStack.getCount();
            if (space <= 0) continue;
            if (space >= remain) {
                inventoryStack.grow(remain);
                return stack.getCount();
            }
            inventoryStack.setCount(inventoryStack.getMaxStackSize());
            added += space;
        }
        if (added >= stack.getCount()) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= container.slots.size() || !(inventoryStack = (slot = container.getSlot(slotIndex.intValue())).getItem()).isEmpty()) continue;
            ItemStack stackToAdd = stack.copy();
            stackToAdd.setCount(stack.getCount() - added);
            slot.set(stackToAdd);
            return stack.getCount();
        }
        return added;
    }

    @Nullable
    private static Slot getSlotWithStack(Container container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
        for (Integer slotNumber : slotNumbers) {
            Slot slot;
            ItemStack slotStack;
            if (slotNumber < 0 || slotNumber >= container.slots.size() || !ItemStack.isSame((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.getSlot(slotNumber.intValue())).getItem())) || !ItemStack.tagMatches((ItemStack)itemStack, (ItemStack)slotStack)) continue;
            return slot;
        }
        return null;
    }
}

