/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;

public class CycleTimer {
    private static final int cycleTime = 1000;
    private long startTime;
    private long drawTime;
    private long pausedDuration = 0L;

    public CycleTimer(int offset) {
        long time = System.currentTimeMillis();
        this.startTime = time - (long)offset * 1000L;
        this.drawTime = time;
    }

    @Nullable
    public <T> T getCycledItem(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        long index = (this.drawTime - this.startTime) / 1000L % (long)list.size();
        return list.get(Math.toIntExact(index));
    }

    public void onDraw() {
        if (!Screen.hasShiftDown()) {
            if (this.pausedDuration > 0L) {
                this.startTime += this.pausedDuration;
                this.pausedDuration = 0L;
            }
            this.drawTime = System.currentTimeMillis();
        } else {
            this.pausedDuration = System.currentTimeMillis() - this.drawTime;
        }
    }
}

