/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory<?> category;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, int x, int y) {
        super(x, y);
        this.logic = logic;
        this.category = category;
    }

    @Override
    public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        if (!clickState.isSimulate()) {
            this.logic.setRecipeCategory(this.category);
            SoundHandler soundHandler = Minecraft.getInstance().getSoundManager();
            soundHandler.play((ISound)SimpleSound.forUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        return this;
    }

    @Override
    public void draw(boolean selected, MatrixStack matrixStack, int mouseX, int mouseY) {
        super.draw(selected, matrixStack, mouseX, mouseY);
        int iconX = this.x + 4;
        int iconY = this.y + 4;
        IDrawable icon = this.category.getIcon();
        if (icon != null) {
            icon.draw(matrixStack, iconX += (16 - icon.getWidth()) / 2, iconY += (16 - icon.getHeight()) / 2);
        } else {
            List<Object> recipeCatalysts = this.logic.getRecipeCatalysts(this.category);
            if (!recipeCatalysts.isEmpty()) {
                Object ingredient = recipeCatalysts.get(0);
                RecipeCategoryTab.renderIngredient(matrixStack, iconX, iconY, ingredient);
            } else {
                String text = this.category.getTitleAsTextComponent().getString().substring(0, 2);
                Minecraft minecraft = Minecraft.getInstance();
                FontRenderer fontRenderer = minecraft.font;
                int textCenterX = this.x + 12;
                int textCenterY = this.y + 12 - 3;
                int color = this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
                int stringCenter = fontRenderer.width(text) / 2;
                fontRenderer.drawShadow(matrixStack, text, (float)(textCenterX - stringCenter), (float)textCenterY, color);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static <T> void renderIngredient(MatrixStack matrixStack, int iconX, int iconY, T ingredient) {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredient);
        RenderSystem.enableDepthTest();
        ingredientRenderer.render(matrixStack, iconX, iconY, ingredient);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableDepthTest();
    }

    @Override
    public boolean isSelected(IRecipeCategory<?> selectedCategory) {
        return this.category.getUid().equals((Object)selectedCategory.getUid());
    }

    @Override
    public List<ITextComponent> getTooltip() {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        ITextComponent title = this.category.getTitleAsTextComponent();
        if (title != null) {
            tooltip.add(title);
        }
        ResourceLocation uid = this.category.getUid();
        String modId = uid.getNamespace();
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add((ITextComponent)new StringTextComponent(modName));
        }
        return tooltip;
    }
}

