/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import mezz.jei.config.ServerInfo;
import mezz.jei.network.PacketHandler;
import mezz.jei.network.packets.PacketJei;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;

public class Network {
    @OnlyIn(value=Dist.CLIENT)
    public static void sendPacketToServer(PacketJei packet) {
        ClientPlayNetHandler netHandler;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null && (netHandler = minecraft.getConnection()) != null && ServerInfo.isJeiOnServer()) {
            Pair<PacketBuffer, Integer> packetData = packet.getPacketData();
            ICustomPacket payload = NetworkDirection.PLAY_TO_SERVER.buildPacket(packetData, PacketHandler.CHANNEL_ID);
            netHandler.send(payload.getThis());
        }
    }

    public static void sendPacketToClient(PacketJei packet, ServerPlayerEntity player) {
        Pair<PacketBuffer, Integer> packetData = packet.getPacketData();
        ICustomPacket payload = NetworkDirection.PLAY_TO_CLIENT.buildPacket(packetData, PacketHandler.CHANNEL_ID);
        player.connection.send(payload.getThis());
    }
}

