/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.CycleTimer;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiIngredient<T>
extends AbstractGui
implements IGuiIngredient<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int slotIndex;
    private final boolean input;
    private final Rectangle2d rect;
    private final int xPadding;
    private final int yPadding;
    private final CycleTimer cycleTimer;
    private final List<T> displayIngredients = new ArrayList<T>();
    private final List<T> allIngredients = new ArrayList<T>();
    private final IIngredientRenderer<T> ingredientRenderer;
    private final IIngredientHelper<T> ingredientHelper;
    private List<ITooltipCallback<T>> tooltipCallbacks = Collections.emptyList();
    @Nullable
    private IDrawable background;
    private boolean enabled;

    public GuiIngredient(int slotIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper, Rectangle2d rect, int xPadding, int yPadding, int cycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.rect = rect;
        this.xPadding = xPadding;
        this.yPadding = yPadding;
        this.cycleTimer = new CycleTimer(cycleOffset);
    }

    public Rectangle2d getRect() {
        return this.rect;
    }

    public boolean isMouseOver(double xOffset, double yOffset, double mouseX, double mouseY) {
        return this.enabled && mouseX >= xOffset + (double)this.rect.getX() && mouseY >= yOffset + (double)this.rect.getY() && mouseX < xOffset + (double)this.rect.getX() + (double)this.rect.getWidth() && mouseY < yOffset + (double)this.rect.getY() + (double)this.rect.getHeight();
    }

    @Override
    @Nullable
    public T getDisplayedIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public List<T> getAllIngredients() {
        return this.allIngredients;
    }

    public void set(@Nullable List<T> ingredients, @Nullable Focus<T> focus) {
        this.displayIngredients.clear();
        this.allIngredients.clear();
        List displayIngredients = ingredients == null ? Collections.emptyList() : ingredients;
        Object match = this.getMatch(displayIngredients, focus);
        if (match != null) {
            this.displayIngredients.add(match);
        } else {
            displayIngredients = this.filterOutHidden(displayIngredients);
            this.displayIngredients.addAll(displayIngredients);
        }
        if (ingredients != null) {
            this.allIngredients.addAll(ingredients);
        }
        this.enabled = !this.displayIngredients.isEmpty();
    }

    private List<T> filterOutHidden(List<T> ingredients) {
        if (ingredients.isEmpty()) {
            return ingredients;
        }
        IngredientFilter ingredientFilter = Internal.getIngredientFilter();
        ArrayList<T> visible = new ArrayList<T>();
        for (T ingredient : ingredients) {
            if (ingredient == null || ingredientFilter.isIngredientVisible(ingredient)) {
                visible.add(ingredient);
            }
            if (visible.size() <= 100) continue;
            return visible;
        }
        if (visible.size() > 0) {
            return visible;
        }
        return ingredients;
    }

    public void setBackground(IDrawable background) {
        this.background = background;
    }

    @Nullable
    private T getMatch(Collection<T> ingredients, @Nullable Focus<T> focus) {
        if (focus != null && this.isMode(focus.getMode())) {
            T focusValue = focus.getValue();
            return this.ingredientHelper.getMatch(ingredients, focusValue, UidContext.Ingredient);
        }
        return null;
    }

    public void setTooltipCallbacks(List<ITooltipCallback<T>> tooltipCallbacks) {
        this.tooltipCallbacks = tooltipCallbacks;
    }

    public void draw(MatrixStack matrixStack, int xOffset, int yOffset) {
        this.cycleTimer.onDraw();
        if (this.background != null) {
            this.background.draw(matrixStack, xOffset + this.rect.getX(), yOffset + this.rect.getY());
        }
        T value = this.getDisplayedIngredient();
        try {
            this.ingredientRenderer.render(matrixStack, xOffset + this.rect.getX() + this.xPadding, yOffset + this.rect.getY() + this.yPadding, value);
        }
        catch (LinkageError | RuntimeException e) {
            if (value != null) {
                throw ErrorUtil.createRenderIngredientException(e, value);
            }
            throw e;
        }
    }

    @Override
    public void drawHighlight(MatrixStack matrixStack, int color, int xOffset, int yOffset) {
        int x = this.rect.getX() + xOffset + this.xPadding;
        int y = this.rect.getY() + yOffset + this.yPadding;
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        GuiIngredient.fill((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + this.rect.getWidth() - this.xPadding * 2), (int)(y + this.rect.getHeight() - this.yPadding * 2), (int)color);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawOverlays(MatrixStack matrixStack, int xOffset, int yOffset, int mouseX, int mouseY) {
        T value = this.getDisplayedIngredient();
        if (value != null) {
            this.drawTooltip(matrixStack, xOffset, yOffset, mouseX, mouseY, value);
        }
    }

    private void drawTooltip(MatrixStack matrixStack, int xOffset, int yOffset, int mouseX, int mouseY, T value) {
        try {
            List<ItemStack> itemStacks;
            ResourceLocation tagEquivalent;
            RenderSystem.disableDepthTest();
            RenderHelper.turnOff();
            GuiIngredient.fill((MatrixStack)matrixStack, (int)(xOffset + this.rect.getX() + this.xPadding), (int)(yOffset + this.rect.getY() + this.yPadding), (int)(xOffset + this.rect.getX() + this.rect.getWidth() - this.xPadding), (int)(yOffset + this.rect.getY() + this.rect.getHeight() - this.yPadding), (int)Integer.MAX_VALUE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
            List<ITextComponent> tooltip = IngredientRenderHelper.getIngredientTooltipSafe(value, this.ingredientRenderer, this.ingredientHelper, modIdHelper);
            for (ITooltipCallback<T> tooltipCallback : this.tooltipCallbacks) {
                tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            if (value instanceof ItemStack && (tagEquivalent = GuiIngredient.getTagEquivalent(itemStacks = this.allIngredients)) != null) {
                TranslationTextComponent acceptsAny = new TranslationTextComponent("jei.tooltip.recipe.tag", new Object[]{tagEquivalent});
                tooltip.add((ITextComponent)acceptsAny.withStyle(TextFormatting.GRAY));
            }
            TooltipRenderer.drawHoveringText(value, tooltip, xOffset + mouseX, yOffset + mouseY, matrixStack);
            RenderSystem.enableDepthTest();
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception when rendering tooltip on {}.", value, (Object)e);
        }
    }

    @Nullable
    private static ResourceLocation getTagEquivalent(Collection<ItemStack> itemStacks) {
        if (itemStacks.size() < 2) {
            return null;
        }
        List items = itemStacks.stream().filter(Objects::nonNull).map(ItemStack::getItem).collect(Collectors.toList());
        ITagCollection collection = ItemTags.getAllTags();
        Collection tags = collection.getAllTags().values();
        for (ITag tag : tags) {
            if (!tag.getValues().equals(items)) continue;
            return collection.getId(tag);
        }
        return null;
    }

    @Override
    public boolean isInput() {
        return this.input;
    }

    public boolean isMode(IFocus.Mode mode) {
        return this.input && mode == IFocus.Mode.INPUT || !this.input && mode == IFocus.Mode.OUTPUT;
    }
}

