/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.ingredients.IngredientInformation;

public class IngredientBlacklistInternal {
    private final Set<String> ingredientBlacklist = new HashSet<String>();

    public <V> void addIngredientToBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        String uniqueName = ingredientHelper.getUniqueId(ingredient);
        this.ingredientBlacklist.add(uniqueName);
    }

    public <V> void removeIngredientFromBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        String uniqueName = ingredientHelper.getUniqueId(ingredient);
        this.ingredientBlacklist.remove(uniqueName);
    }

    public <V> boolean isIngredientBlacklistedByApi(V ingredient, IIngredientHelper<V> ingredientHelper) {
        List<String> uids = IngredientInformation.getUniqueIdsWithWildcard(ingredientHelper, ingredient);
        for (String uid : uids) {
            if (!this.ingredientBlacklist.contains(uid)) continue;
            return true;
        }
        return false;
    }
}

