/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;

public class LeftAreaDispatcher
implements IShowsRecipeFocuses,
IPaged {
    private static final int BORDER_PADDING = 2;
    private static final int NAVIGATION_HEIGHT = 20;
    private final List<ILeftAreaContent> contents = new ArrayList<ILeftAreaContent>();
    private final GuiScreenHelper guiScreenHelper;
    private int current = 0;
    @Nullable
    private IGuiProperties guiProperties;
    private Rectangle2d naviArea = new Rectangle2d(0, 0, 0, 0);
    private Rectangle2d displayArea = new Rectangle2d(0, 0, 0, 0);
    private final PageNavigation navigation;
    private boolean canShow = false;

    public LeftAreaDispatcher(GuiScreenHelper guiScreenHelper) {
        this.guiScreenHelper = guiScreenHelper;
        this.navigation = new PageNavigation(this, false);
    }

    public void addContent(ILeftAreaContent content) {
        this.contents.add(content);
    }

    private boolean hasContent() {
        return this.current >= 0 && this.current < this.contents.size();
    }

    public void drawScreen(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.canShow && this.hasContent()) {
            this.contents.get(this.current).drawScreen(minecraft, mouseX, mouseY, partialTicks);
            if (this.naviArea.func_199317_d() > 0) {
                this.navigation.draw(minecraft, mouseX, mouseY, partialTicks);
            }
        }
    }

    public void drawOnForeground(ContainerScreen gui, int mouseX, int mouseY) {
        if (this.canShow && this.hasContent()) {
            this.contents.get(this.current).drawOnForeground(gui, mouseX, mouseY);
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.canShow && this.hasContent()) {
            this.contents.get(this.current).drawTooltips(minecraft, mouseX, mouseY);
        }
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean forceUpdate) {
        this.canShow = false;
        if (this.hasContent()) {
            IGuiProperties currentGuiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
            if (currentGuiProperties == null) {
                this.guiProperties = null;
            } else {
                ILeftAreaContent content = this.contents.get(this.current);
                if (forceUpdate || !GuiProperties.areEqual(this.guiProperties, currentGuiProperties)) {
                    Set<Rectangle2d> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
                    this.guiProperties = currentGuiProperties;
                    this.makeDisplayArea(this.guiProperties);
                    content.updateBounds(this.displayArea, guiExclusionAreas);
                    this.canShow = true;
                } else {
                    this.canShow = true;
                }
            }
        }
    }

    private void makeDisplayArea(IGuiProperties guiProperties) {
        int x = 2;
        int y = 2;
        int width = guiProperties.getGuiLeft() - 2 - 2;
        int height = guiProperties.getScreenHeight() - 2 - 2;
        this.displayArea = new Rectangle2d(2, 2, width, height);
        if (this.contents.size() > 1) {
            this.naviArea = new Rectangle2d(this.displayArea.func_199318_a(), this.displayArea.func_199319_b(), this.displayArea.func_199316_c(), 20);
            this.displayArea = new Rectangle2d(this.displayArea.func_199318_a(), this.displayArea.func_199319_b() + 20 + 2, this.displayArea.func_199316_c(), this.displayArea.func_199317_d() - 20 + 2);
            this.navigation.updateBounds(this.naviArea);
        } else {
            this.naviArea = new Rectangle2d(0, 0, 0, 0);
        }
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.canShow && this.hasContent()) {
            return this.contents.get(this.current).getIngredientUnderMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        if (this.canShow && this.hasContent()) {
            return this.contents.get(this.current).canSetFocusWithMouse();
        }
        return false;
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.canShow && this.hasContent()) {
            if (MathUtil.contains(this.displayArea, mouseX, mouseY)) {
                return this.contents.get(this.current).handleMouseScrolled(mouseX, mouseY, dWheel);
            }
            if (MathUtil.contains(this.naviArea, mouseX, mouseY)) {
                if (dWheel < 0.0) {
                    this.nextPage();
                } else {
                    this.previousPage();
                }
                return true;
            }
        }
        return false;
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.canShow && this.hasContent()) {
            if (MathUtil.contains(this.displayArea, mouseX, mouseY)) {
                return this.contents.get(this.current).handleMouseClicked(mouseX, mouseY, mouseButton);
            }
            if (MathUtil.contains(this.naviArea, mouseX, mouseY)) {
                return this.navigation.handleMouseClickedButtons(mouseX, mouseY, mouseButton);
            }
        }
        return false;
    }

    @Override
    public boolean nextPage() {
        ++this.current;
        if (this.current >= this.contents.size()) {
            this.current = 0;
        }
        this.navigation.updatePageState();
        return true;
    }

    @Override
    public boolean previousPage() {
        --this.current;
        if (this.current < 0) {
            this.current = this.contents.size();
        }
        this.navigation.updatePageState();
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.contents.size() - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.current > 0;
    }

    @Override
    public int getPageCount() {
        return this.contents.size();
    }

    @Override
    public int getPageNumber() {
        return this.current;
    }
}

