/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableBlank;
import mezz.jei.gui.elements.GuiIconButton;
import net.minecraft.client.renderer.Rectangle2d;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private final HoverChecker hoverChecker;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(new DrawableBlank(0, 0), b -> {});
        this.hoverChecker = new HoverChecker();
        this.hoverChecker.updateBounds(this.button);
    }

    public void updateBounds(Rectangle2d area) {
        this.button.setWidth(area.func_199316_c());
        this.button.setHeight(area.func_199317_d());
        this.button.x = area.func_199318_a();
        this.button.y = area.func_199319_b();
        this.hoverChecker.updateBounds(this.button);
    }

    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.button.render(mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(this.button.x + 2, this.button.y + 2);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public final boolean handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        return this.button.mouseClicked(mouseX, mouseY, mouseButton) && this.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    public final void drawTooltips(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(tooltip, mouseX, mouseY, 150);
        }
    }

    protected abstract void getTooltips(List<String> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(double var1, double var3, int var5);
}

