/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class DrawableResource
implements IDrawableStatic {
    private final ResourceLocation resourceLocation;
    private final int textureWidth;
    private final int textureHeight;
    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final int paddingTop;
    private final int paddingBottom;
    private final int paddingLeft;
    private final int paddingRight;

    public DrawableResource(ResourceLocation resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight, int textureWidth, int textureHeight) {
        this.resourceLocation = resourceLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
    }

    @Override
    public int getWidth() {
        return this.width + this.paddingLeft + this.paddingRight;
    }

    @Override
    public int getHeight() {
        return this.height + this.paddingTop + this.paddingBottom;
    }

    @Override
    public void draw(int xOffset, int yOffset) {
        this.draw(xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(this.resourceLocation);
        int x = xOffset + this.paddingLeft + maskLeft;
        int y = yOffset + this.paddingTop + maskTop;
        int u = this.u + maskLeft;
        int v = this.v + maskTop;
        int width = this.width - maskRight - maskLeft;
        int height = this.height - maskBottom - maskTop;
        float f = 1.0f / (float)this.textureWidth;
        float f1 = 1.0f / (float)this.textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_((float)u * f, ((float)v + (float)height) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(((float)u + (float)width) * f, ((float)v + (float)height) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_(((float)u + (float)width) * f, (float)v * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_((float)u * f, (float)v * f1).func_181675_d();
        tessellator.func_78381_a();
    }
}

