/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class GuiScreenHelper {
    private final IngredientManager ingredientManager;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final ListMultiMap<Class<? extends ContainerScreen>, IGuiContainerHandler<?>> guiHandlers;
    private final Map<Class, IGhostIngredientHandler> ghostIngredientHandlers;
    private final Map<Class, IScreenHandler> guiScreenHandlers;
    private Set<Rectangle2d> guiExclusionAreas = Collections.emptySet();

    public GuiScreenHelper(IngredientManager ingredientManager, List<IGlobalGuiHandler> globalGuiHandlers, ListMultiMap<Class<? extends ContainerScreen>, IGuiContainerHandler<?>> guiHandlers, Map<Class, IGhostIngredientHandler> ghostIngredientHandlers, Map<Class, IScreenHandler> guiScreenHandlers) {
        this.ingredientManager = ingredientManager;
        this.globalGuiHandlers = globalGuiHandlers;
        this.guiHandlers = guiHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
    }

    @Nullable
    public <T extends Screen> IGuiProperties getGuiProperties(@Nullable T screen) {
        if (screen == null) {
            return null;
        }
        IScreenHandler handler = this.guiScreenHandlers.get(screen.getClass());
        if (handler != null) {
            return handler.apply(screen);
        }
        for (Map.Entry<Class, IScreenHandler> entry : this.guiScreenHandlers.entrySet()) {
            IScreenHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(screen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(screen);
        }
        return null;
    }

    public boolean updateGuiExclusionAreas() {
        Set<Rectangle2d> guiAreas = this.getPluginsExclusionAreas();
        if (!guiAreas.equals(this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas.stream().map(r -> new Rectangle2d(r.func_199318_a(), r.func_199319_b(), r.func_199316_c(), r.func_199317_d())).collect(Collectors.toSet());
            return true;
        }
        return false;
    }

    public Set<Rectangle2d> getGuiExclusionAreas() {
        return this.guiExclusionAreas;
    }

    public boolean isInGuiExclusionArea(double mouseX, double mouseY) {
        return MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    private Set<Rectangle2d> getPluginsExclusionAreas() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen == null) {
            return Collections.emptySet();
        }
        HashSet<Rectangle2d> allGuiExtraAreas = new HashSet<Rectangle2d>();
        if (screen instanceof ContainerScreen) {
            ContainerScreen guiContainer = (ContainerScreen)screen;
            List<IGuiContainerHandler<ContainerScreen>> activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiContainer);
            for (IGuiContainerHandler<ContainerScreen> advancedGuiHandler : activeAdvancedGuiHandlers) {
                List<Rectangle2d> guiExtraAreas = advancedGuiHandler.getGuiExtraAreas(guiContainer);
                allGuiExtraAreas.addAll(guiExtraAreas);
            }
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            Collection<Rectangle2d> guiExtraAreas = globalGuiHandler.getGuiExtraAreas();
            allGuiExtraAreas.addAll(guiExtraAreas);
        }
        return allGuiExtraAreas;
    }

    @Nullable
    public <T extends ContainerScreen> IClickedIngredient<?> getPluginsIngredientUnderMouse(T guiContainer, double mouseX, double mouseY) {
        IClickedIngredient<Object> clickedIngredient;
        Object clicked;
        List<IGuiContainerHandler<T>> activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiContainer);
        for (IGuiContainerHandler<T> advancedGuiHandler : activeAdvancedGuiHandlers) {
            clicked = advancedGuiHandler.getIngredientUnderMouse(guiContainer, mouseX, mouseY);
            clickedIngredient = this.createClickedIngredient(clicked, guiContainer);
            if (clickedIngredient == null) continue;
            return clickedIngredient;
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            clicked = globalGuiHandler.getIngredientUnderMouse(mouseX, mouseY);
            clickedIngredient = this.createClickedIngredient(clicked, guiContainer);
            if (clickedIngredient == null) continue;
            return clickedIngredient;
        }
        return null;
    }

    @Nullable
    public <T extends Screen> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class, IGhostIngredientHandler> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler handler2;
            Class guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private <T> IClickedIngredient<T> createClickedIngredient(@Nullable T ingredient, ContainerScreen guiContainer) {
        if (ingredient != null && this.ingredientManager.isValidIngredient(ingredient)) {
            Rectangle2d area = null;
            Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
            if (ingredient instanceof ItemStack && slotUnderMouse != null && ItemStack.func_77989_b((ItemStack)slotUnderMouse.func_75211_c(), (ItemStack)((ItemStack)ingredient))) {
                area = new Rectangle2d(slotUnderMouse.field_75223_e, slotUnderMouse.field_75221_f, 16, 16);
            }
            return ClickedIngredient.create(ingredient, area);
        }
        return null;
    }

    private <T extends ContainerScreen> List<IGuiContainerHandler<T>> getActiveAdvancedGuiHandlers(T guiContainer) {
        ArrayList<IGuiContainerHandler<T>> activeAdvancedGuiHandler = new ArrayList<IGuiContainerHandler<T>>();
        for (Map.Entry entry : this.guiHandlers.entrySet()) {
            Class guiContainerClass = (Class)entry.getKey();
            if (!guiContainerClass.isInstance(guiContainer)) continue;
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                IGuiContainerHandler guiContainerHandler;
                IGuiContainerHandler guiContainerHandlerCast = guiContainerHandler = (IGuiContainerHandler)iterator.next();
                activeAdvancedGuiHandler.add(guiContainerHandlerCast);
            }
        }
        return activeAdvancedGuiHandler;
    }

    @Nullable
    public IGuiClickableArea getGuiClickableArea(ContainerScreen guiContainer, double mouseX, double mouseY) {
        for (Map.Entry entry : this.guiHandlers.entrySet()) {
            Class guiHandlerClass = (Class)entry.getKey();
            List guiHandlers = (List)entry.getValue();
            for (IGuiContainerHandler guiHandler : guiHandlers) {
                IGuiClickableArea guiClickableArea = GuiScreenHelper.getGuiClickableArea(guiHandlerClass, guiHandler, guiContainer, mouseX, mouseY);
                if (guiClickableArea == null) continue;
                return guiClickableArea;
            }
        }
        return null;
    }

    @Nullable
    private static <T extends ContainerScreen> IGuiClickableArea getGuiClickableArea(Class<? extends T> handlerClass, IGuiContainerHandler<T> handler, ContainerScreen containerScreen, double mouseX, double mouseY) {
        if (handlerClass.isInstance(containerScreen)) {
            ContainerScreen castContainer = (ContainerScreen)handlerClass.cast(containerScreen);
            Collection<IGuiClickableArea> guiClickableAreas = handler.getGuiClickableAreas(castContainer, mouseX, mouseY);
            for (IGuiClickableArea guiClickableArea : guiClickableAreas) {
                if (!MathUtil.contains(guiClickableArea.getArea(), mouseX, mouseY)) continue;
                return guiClickableArea;
            }
        }
        return null;
    }
}

