/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.config.Constants;
import mezz.jei.plugins.vanilla.furnace.FurnaceRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FurnaceSmeltingCategory
extends FurnaceRecipeCategory<FurnaceRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public FurnaceSmeltingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 114, 82, 54);
        this.icon = guiHelper.createDrawableIngredient(new ItemStack((IItemProvider)Blocks.field_150460_al));
        this.localizedName = Translator.translateToLocal("gui.jei.category.smelting");
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setIngredients(FurnaceRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List<Ingredient>)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, recipe.func_77571_b());
    }

    @Override
    public void draw(FurnaceRecipe recipe, double mouseX, double mouseY) {
        this.animatedFlame.draw(1, 20);
        this.arrow.draw(24, 18);
        float experience = recipe.func_201831_g();
        if (experience > 0.0f) {
            String experienceString = Translator.translateToLocalFormatted("gui.jei.category.smelting.experience", Float.valueOf(experience));
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_211126_b(experienceString, (float)(this.background.getWidth() - stringWidth), 0.0f, -8355712);
        }
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.FURNACE;
    }

    @Override
    public Class<? extends FurnaceRecipe> getRecipeClass() {
        return FurnaceRecipe.class;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, FurnaceRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

